set -ex

printenv

if [ -z "$PROJECTS" ] ; then
    exit 1
fi

if [ -z "$PACKAGE_VERSION" ] ; then
    test "$BRANCH" = "default" && export NAME="$BRANCH" || export NAME=`echo "$BRANCH" | cut -d/ -f3`
    export PACKAGE_VERSION="$(date +%Y%m%d%H%M).$(echo $NAME | tr -d '_-')"
fi

echo "PACKAGE_VERSION=$PACKAGE_VERSION" > package_version.properties

cd $WORKSPACE/arcadia

# Building projects
BLD_LIST=""

for p in $PROJECTS; do
    case $p in
        mopsdb-cron)
            BLD_LIST="$BLD_LIST mail/pg/mopsdb/cron"
            ;;
        config_fetcher)
            BLD_LIST="$BLD_LIST mail/catdog/config_fetcher"
            ;;
        catdog)
            BLD_LIST="$BLD_LIST mail/catdog/catdog"
            ;;
        *)
            BLD_LIST="$BLD_LIST mail/$p"
            ;;
    esac
done

[ "$RUN_ARCADIA_TEST" = "true" ] && ya_flags="-ttt"
[ "$STRIP_BINARIES" = "true" ] && ya_flags="$ya_flags -DSTRIP_BINARIES"
./ya make mail/wmi-qa $BLD_LIST --build=release --checkout $ya_flags;


# Stripping binaries
if [ "$STRIP_BINARIES" = "true" ]; then
    STRIP_LIST="";
    LS_PATHS="";
    for dog in $PROJECTS; do
        case $dog in
            doberman)
                STRIP_LIST="$STRIP_LIST project_path=mail/doberman;bin_path=src/doberman"
                LS_PATHS="$LS_PATHS mail/doberman/src/doberman*"
                ;;
            ymsettings)
                STRIP_LIST="$STRIP_LIST project_path=mail/ymsettings;bin_path=src/bin/yserver_settings"
                LS_PATHS="$LS_PATHS mail/ymsettings/src/bin/yserver_settings*"
                ;;
            hound)
                STRIP_LIST="$STRIP_LIST project_path=mail/hound;bin_path=bin/hound2"
                LS_PATHS="$LS_PATHS mail/hound/bin/hound2*"
                ;;
            message_body)
                STRIP_LIST="$STRIP_LIST project_path=mail/message_body;bin_path=bin/mbody"
                LS_PATHS="$LS_PATHS mail/message_body/bin/mbody*"
                ;;
            *)
                STRIP_LIST="$STRIP_LIST project_path=mail/$dog;bin_path=bin/$dog"
                LS_PATHS="$LS_PATHS mail/$dog/bin/$dog*"
                ;;
        esac
    done
    python3 mail/wmi-qa/for_strip_binaries/generate_symbols_url.py $STRIP_LIST
    ls -lathH $LS_PATHS
fi


# Making packages
PKG_LIST=""

add_pkg() {
    case $1 in
        mops)
            add_pkg mopsdb
            PKG_LIST="$PKG_LIST mail/$1/package/package.json"
            ;;
        mopsdb)
            PKG_LIST="$PKG_LIST mail/pg/$1/package/package.json"
            ;;
        barbet)
            add_pkg queuedb
            PKG_LIST="$PKG_LIST mail/$1/package/package.json"
            ;;
        spaniel)
            add_pkg queuedb
            add_pkg spanieldb
            PKG_LIST="$PKG_LIST mail/$1/package/package.json"
            ;;
        queuedb)
            PKG_LIST="$PKG_LIST mail/pg/$1/package/package.json"
            ;;
        spanieldb)
            PKG_LIST="$PKG_LIST mail/pg/$1/package/package.json"
            ;;
        ymsettings)
            PKG_LIST="$PKG_LIST mail/$1/package/settings.json"
            ;;
        mopsdb-cron)
            PKG_LIST="$PKG_LIST mail/pg/mopsdb/cron/package/package.json"
            ;;
        config_fetcher)
            PKG_LIST="$PKG_LIST mail/catdog/config_fetcher/package/package.json"
            ;;
        catdog)
            PKG_LIST="$PKG_LIST mail/catdog/catdog/package/package.json"
            ;;
        *)
            PKG_LIST="$PKG_LIST mail/$1/package/package.json"
            ;;
    esac
}

for i in $PROJECTS; do
    add_pkg $i
done

./ya package $PKG_LIST --custom-version=$PACKAGE_VERSION --build=release --checkout $ya_flags;

# Building docker images
wait_pids() {
    FAIL=0
    for pid in $1; do
        wait $pid || let "FAIL+=1"
    done

    if [ $FAIL -ne 0 ];
        then
           exit 1
    fi
}

PACKAGES=""
for p in $PROJECTS; do
    case $p in
        mops)
            PACKAGES="$PACKAGES mops mopsdb"
            ;;
        barbet)
            PACKAGES="$PACKAGES barbet queuedb"
            ;;
        spaniel)
            PACKAGES="$PACKAGES spaniel queuedb spanieldb"
            ;;
        message_body)
            PACKAGES="$PACKAGES mbody"
            ;;
        ymsettings)
            PACKAGES="$PACKAGES settings"
            ;;
        *)
            PACKAGES="$PACKAGES $p"
            ;;
    esac
done

BUILD_PIDS=""

get_image_name() {
    IMAGE_NAME=$1
    if [ "$IMAGE_NAME" == "hound" ]; then
        IMAGE_NAME="hound2"
    fi
}

for p in $PACKAGES; do
    get_image_name "$p"
    docker build --pull -t registry.yandex.net/mail/$p/$p:$PACKAGE_VERSION - < $IMAGE_NAME.$PACKAGE_VERSION.tar.gz &
    BUILD_PIDS="$BUILD_PIDS $!"
done

wait_pids "$BUILD_PIDS"

# Pushing docker images
PUSH_PIDS=""

for p in $PACKAGES; do
    docker push registry.yandex.net/mail/$p/$p:$PACKAGE_VERSION &
    PUSH_PIDS="$PUSH_PIDS $!"
done

wait_pids "$PUSH_PIDS"
