multiJob('build-collie-packages') {
    description('''
Сборка образа collie
<br/>
Эта джоба сгенерирована автоматически.
<br/>
<img src="https://common.jenkins.mail.yandex.net/job/build-collie-packages/buildTimeGraph/png" />
<br/>
    ''')

    logRotator(30, 200, 30, 200)
    concurrentBuild()
    label('maildev')

    parameters {
        stringParam('BRANCH', 'default', '"asg#my_branch" для asg или "review#review_number#human_name" для ревью или "svn#trunk|revision" для svn')
    }

    wrappers {
        timestamps()

        buildName('${ENV,var="BRANCH"}')
        colorizeOutput('xterm')
        sshAgent('robot-gerrit-ssh-key')

        preBuildCleanup {
            includePattern('asg/**')
            includePattern('arcadia/**')
            deleteDirectories(true)
        }
    }

    steps {
        shell(readFileFromWorkspace('arcadia/mail/jenkins_groovy/yamail-wmi-jobs/parse_build_properties.sh'))

        buildDescription('', '$PACKAGE_VERSION')

        phase('BUILD') {
            phaseJob('build-arcadia-packages') {
                parameters {
                    propertiesFile('build.properties')
                    predefinedProp('PROJECTS', 'collie')
                    booleanParam('RUN_ARCADIA_TEST', true)
                }
            }
        }
    }
}
