freeStyleJob('check-aqua-packs') {
    displayName('Джоба проверяет что все тесты добавлены в паки аквы')

    label('maildev')

    wrappers {
        timestamps()
        colorizeOutput('xterm')
    }

    triggers {
        cron('0 23 * * 1-5')
    }

    steps {
        shell('''
pip3 install requests

python3 -c "
import sys
import json
import requests


suit_in_packs = {}


def main(project_resp, pack_resps):
    suites = project_resp['suites']
    project_id = project_resp['id']
    suit_in_packs = { s['id']: [] for s in suites }
    id_to_name = { s['id']: s['name'] for s in suites }

    for resp in pack_resps:
        name = resp['name']
        for selected_project in filter(lambda rr: rr['id'] == project_id, resp['projects']):
            for suite in selected_project['suites']:
                suite_id = suite['suite']['id']
                suit_in_packs[suite_id].append(name)

    sum = 0
    for p_id, packs in suit_in_packs.items():
        if(len(packs) == 0):
            print(id_to_name[p_id])
            sum += 1

    return sum


if __name__ == '__main__':
    host = 'https://aqua.yandex-team.ru/aqua-api'
    project_name = 'ru.yandex.autotests:wmi-tests:1.4.1-SNAPSHOT'
    pack_url = host + '/services/pack/'
    project_url = host + '/services/project/' + project_name

    packs = {
        'wmi_pg': '558bfd6be4b04d012f267ec2',
        'webcorp': '52f26d7ae4b0325d65c6318d',
        'mock': '552e41ebe4b00c306643e64f',
        'sendbernar': '585d2973e4b04506a0ac5ec2',
        'webattach': '550c4201e4b0fb0c29be7632',
        'hound2': '5a980bfe6412986e2b6e9c8a',
        'mops': '5a2698836412ad01a99e2021',
        'asyncmops': '5dae047e8a900e03944427e5',
        'b2b': '51a8a62684ae47ee5cb9756d',
        'akita': '5ae3220e4a94db72c9e80a68',
        'mbody': '5af9368d4a94db72c9ecae25',
        'barbet': '605dcc9f8a90fe6cefeb3bc5',
        'spaniel': '612520fd8a90449c9e78d3b9',
    }

    packs = [
        requests.get(pack_url + str(p), verify=False).json() for p in packs.values()
    ]
    project = requests.get(project_url, verify=False).json()

    sys.exit(main(project, packs))
"
            ''')
    }

    publishers {
        mailer('webmail-team@yandex-team.ru')
    }
}

