clone_asg() {
    cd $WORKSPACE
    
    for (( i=1; i <= 5; i++ )); do
        git clone --depth 1 ssh://git@bb.yandex-team.ru/mail/asg.git asg && break
        sleep 5
    done

    $WORKSPACE/asg/asg clone arcadia --branch $BRANCH
}

clone_review() {
    cd $WORKSPACE
    svn cat "svn+ssh://$USERNAME@arcadia.yandex.ru/arc/trunk/arcadia/ya" | python - clone
    cd arcadia/

    ./ya unshelve -a $BRANCH
}

clone_svn() {
    cd $WORKSPACE
    svn cat "svn+ssh://$USERNAME@arcadia.yandex.ru/arc/trunk/arcadia/ya" | python - clone
    cd arcadia/

    if [ "$BRANCH" = "trunk" ]; then
        ./ya tool svn up .
    else
        ./ya tool svn up -r "$BRANCH" .
    fi
}

USERNAME='robot-gerrit'
[[ ! -z "$VCS_USERNAME" ]] && USERNAME=`echo "$VCS_USERNAME" | sed 's/-ssh-key//g'`

case $VCS in
    asg)
        clone_asg
        ;;
    svn)
        clone_svn
        ;;
    review)
        clone_review
        ;;
    *)
        clone_svn
        ;;
esac
