freeStyleJob('docker-login-job') {
    description('''
Логинится в докере из-под robot-gerrit
<br/>
Эта джоба сгенерирована автоматически. <br/>
<img src="https://common.jenkins.mail.yandex.net/job/docker-login-job/buildTimeGraph/png" />
<br/>
    ''')

    logRotator(30, 200, 30, 200)
    concurrentBuild()

    wrappers {
        timestamps()

        buildName('${LABEL}')
        colorizeOutput('xterm')
        sshAgent('robot-gerrit-ssh-key')

        preBuildCleanup()
    }

    environmentVariables {
        env('VCS', 'svn')
        env('BRANCH', 'trunk')
    }

    steps {
        shell(readFileFromWorkspace('arcadia/mail/jenkins_groovy/yamail-wmi-jobs/clone_arcadia.sh'))
        shell(readFileFromWorkspace('arcadia/mail/jenkins_groovy/yamail-wmi-jobs/docker_login.sh'))
    }
}

multiJob('docker-login') {
    displayName('Запускает docker login от имени robot-gerrit на всех maildev тачках')

    label('maildev')

    logRotator(30, 200, 30, 200)

    wrappers {
        timestamps()
        preBuildCleanup()
        colorizeOutput('xterm')
    }

    triggers {
        cron('0 1 * * *')
    }

    steps {
        phase('DOCKER LOGIN') {
            for(i = 1; i <= 6; i++) {
                phaseJob('docker-login-job') {
                    killPhaseCondition('NEVER')
                    parameters {
                        currentBuild()
                        nodeLabel('LABEL', 'maildev'+i+'.vla.yp-c.yandex.net')
                    }
                }
            }
        }
    }
}
