freeStyleJob('execute-on-host') {
    description('Выполняет скрипт на хосте')

    logRotator(30, 200, 30, 200)
    concurrentBuild()

    parameters {
        labelParam('LABEL') {
            defaultValue('maildev')
        }
        textParam('SCRIPT', '#!/bin/bash')
    }

    wrappers {
        timestamps()

        colorizeOutput('xterm')
        sshAgent('robot-gerrit-ssh-key')
    }

    steps {
        shell('''
FILE="$(mktemp)"
echo "$SCRIPT" > "$FILE"
bash "$FILE"
''')
    }
}

multiJob('foreach') {
    displayName('Выполняет скрипт для всех maildev тачек')

    label('maildev')

    logRotator(30, 200, 30, 200)

    parameters {
        textParam('SCRIPT', '#!/bin/bash')
    }

    wrappers {
        timestamps()
        preBuildCleanup()
        buildName('$BRANCH')
        colorizeOutput('xterm')
    }

    steps {
        phase('BUILD WEBMAIL') {
            for(i = 1; i <= 6; i++) {
                phaseJob('execute-on-host') {
                    killPhaseCondition('NEVER')
                    parameters {
                        currentBuild()
                        nodeLabel('LABEL', 'maildev'+i+'.vla.yp-c.yandex.net')
                    }
                }
            }
        }
    }
}
