freeStyleJob('launch-webmail-containers') {
    displayName('Джоба для поднятия сервисов в qloud')
    description("""Эта джоба сгенерирована автоматически.
            <br/>
            <h2>Время прогона</h2>
            <br/>
            <img src="https://common.jenkins.mail.yandex.net/job/launch-webmail-containers/buildTimeGraph/png" />""")

    label('maildev')

    parameters {
        stringParam('VCS', 'svn')
        stringParam('BRANCH', 'trunk')
        stringParam('PROJECTS', '')
        stringParam('PACKAGE_VERSION', '')
        stringParam('ENVIRONMENT_TYPE', 'testing')
    }

    concurrentBuild(false) // специально

    wrappers {
        timestamps()
        preBuildCleanup()
        buildName('$PACKAGE_VERSION')
        colorizeOutput('xterm')
        sshAgent('robot-gerrit-ssh-key')
    }

    steps {
        buildDescription('', '${PACKAGE_VERSION}')
        shell(readFileFromWorkspace('arcadia/mail/jenkins_groovy/yamail-wmi-jobs/clone_arcadia.sh'))
        shell('''
cd $WORKSPACE/arcadia
set +ex
TOKEN=$(./ya vault get version sec-01d34s477p8fak79sq374swfqa -o platform.oauth.token)
set -ex
./ya make --checkout mail/wmi-qa
cd mail/wmi-qa
./make.sh -v "$PACKAGE_VERSION" -t "$TOKEN" -o "$WORKSPACE/hosts.props" -q "$WORKSPACE/arcadia/ya tool jq" -w "./wmi-qa" -p "$PROJECTS"
./postinst.sh
''')
    }

    publishers {
        archiveArtifacts {
            pattern('hosts.props')
            allowEmpty(false)
        }
    }
}


def launch_smtpgate_containers(name_suffix, label_name, ssh_agent_name, application_name, vault_id, base_dir) {
    freeStyleJob('launch-smtpgate-containers' + name_suffix) {
        displayName('Джоба для поднятия сервисов в qloud для тестов smtpgate')
        description("""Эта джоба сгенерирована автоматически.
                <br/>
                <h2>Время прогона</h2>
                <br/>
                <img src="https://common.jenkins.mail.yandex.net/job/launch-smtpgate-containers/buildTimeGraph/png" />""")

        label(label_name)

        parameters {
            stringParam('VCS', 'svn')
            stringParam('BRANCH', 'trunk')
            stringParam('PACKAGE_VERSION', '')
            stringParam('HOST_SMTPGATE', '')
        }

        environmentVariables {
            env('PROJECTS', 'sendbernar hound mbody')
            env('VCS_USERNAME', ssh_agent_name)
            env('PREFIX', 'smtpgate-')
        }

        concurrentBuild(false) // специально

        wrappers {
            timestamps()
            preBuildCleanup()
            buildName('$PACKAGE_VERSION')
            colorizeOutput('xterm')
            sshAgent(ssh_agent_name)
        }

        steps {
            buildDescription('', '${PACKAGE_VERSION}')
            shell(readFileFromWorkspace('arcadia/mail/jenkins_groovy/yamail-wmi-jobs/clone_arcadia.sh'))
            shell('''
    cd $WORKSPACE/arcadia
    set +ex
    TOKEN=$(./ya vault get version ''' + vault_id + ''' -o platform.oauth.token)
    set -ex
    ./ya make --checkout mail/wmi-qa
    cd mail/wmi-qa
    ./copy_production_components.sh -v "$PACKAGE_VERSION" -t "$TOKEN" -o "$WORKSPACE/hosts.props" -q "$WORKSPACE/arcadia/ya tool jq" -w "./wmi-qa" -p "$PROJECTS" -f "$PREFIX" -e "mail.''' + application_name + '''" -z "HOST_SMTPGATE=$HOST_SMTPGATE\\nOVERRIDE_HOST_CALLBACK=true" -b "''' + base_dir + '''"
    ''')
        }

        publishers {
            archiveArtifacts {
                pattern('hosts.props')
                allowEmpty(false)
            }
        }
    }
}

launch_smtpgate_containers('', 'maildev', 'robot-gerrit-ssh-key', 'wmi-qa', 'sec-01d34s477p8fak79sq374swfqa', 'environment')
launch_smtpgate_containers('-prestable', 'robot_wmi_label',  'robot-wmi-ssh-key', 'wmi-prestable', 'sec-01dt73pna8n09gmnztkn9eab28', 'prestable')
