def loadtest_packages(name) {
    def clone_arcadia = readFileFromWorkspace('arcadia/mail/jenkins_groovy/yamail-wmi-jobs/clone_arcadia.sh')
    def loadtest_packages = readFileFromWorkspace('arcadia/mail/jenkins_groovy/yamail-wmi-jobs/loadtest_packages.sh')

    freeStyleJob('loadtest-' + name + '-packages') {
        displayName('Нагрузочно стреляем по ' + name + ' в qloud')
        description("""Эта джоба сгенерирована автоматически.
                <br/>
                <a href='https://jenkins-load.yandex-team.ru/job/""" + name + """_qloud'>https://jenkins-load.yandex-team.ru/job/""" + name + """_qloud</a>
                <br/>
                <h1 style='color:red;'>Отмена этой джобы не отменит сами стрельбы</h1>
                <br/>
                <h2>Время прогона</h2>
                <br/>
                <img src="https://jenkins-load.yandex-team.ru/job/""" + name + """_qloud/buildTimeGraph/png" />""")

        label('maildev')

        logRotator(30, 200, 30, 200)

        parameters {
            stringParam('PACKAGE_VERSION', '', 'Версия пакетов для установки')
            stringParam('JIRA_TASKS', '', 'Список задач через пробел, например "WMI-111 DARIA-222 WMI-333"')
            stringParam('SUFFIX', '', 'Дополнительное описание стрельбы. Будет добавлено в тайтл стрельбы в Лунапарке в квадратных скобках и в коммент к деплою окружения в qloud')
            stringParam('BRANCH', 'trunk', 'Ветка, с которой загружать параметры пакета')
            stringParam('VCS', 'svn', 'Система управления версиями.')
            booleanParam('LOGROTATION', false, 'Ротировать ли логи перед стрельбами')
        }

        concurrentBuild(false)

        wrappers {
            timestamps()
            preBuildCleanup()
            buildName('[$JIRA_TASKS] $PACKAGE_VERSION')
            colorizeOutput('xterm')
            sshAgent('robot-gerrit-ssh-key')
        }

        environmentVariables {
            env('PROJECT', name)
        }

        steps {
            configure { node ->
                node / 'builders' << 'hudson.tasks.Shell' {
                    command(clone_arcadia)
                }
            }

            configure { node ->
                node / 'builders' << 'hudson.tasks.Shell' {
                    command(loadtest_packages)
                }
            }

            configure { node ->
                node / 'builders' << 'EnvInjectBuilder' {
                    info {
                        propertiesFilePath('$WORKSPACE/profile.properties')
                    }
                }
            }

            configure { node ->
                node / 'builders' << 'org.jenkinsci.plugins.ParameterizedRemoteTrigger.RemoteBuildConfiguration'(plugin: 'Parameterized-Remote-Trigger@3.0.6') {
                    token('lunapi')
                    remoteJenkinsUrl('https://jenkins-load.yandex-team.ru')
                    job('${PROJECT}_qloud')
                    blockBuildUntilComplete(true)
                    enhancedLogging(true)
                    pollInterval(10)
                    connectionRetryLimit(5)
                    preventRemoteBuildQueue(true)
                    shouldNotFailBuild(false)
                    parameters('''
TASK=$JIRA_TASKS
SUFFIX=[$JIRA_TASKS][$PACKAGE_VERSION]$SUFFIX
SCHEDULE=$SCHEDULE_CONST
PROFILE=$LOAD_PROFILE
                    ''')
                }
            }
            configure { node ->
                node / 'builders' << 'org.jenkinsci.plugins.ParameterizedRemoteTrigger.RemoteBuildConfiguration'(plugin: 'Parameterized-Remote-Trigger@3.0.6') {
                    token('lunapi')
                    remoteJenkinsUrl('https://jenkins-load.yandex-team.ru')
                    job('${PROJECT}_qloud')
                    blockBuildUntilComplete(true)
                    enhancedLogging(true)
                    pollInterval(10)
                    connectionRetryLimit(5)
                    preventRemoteBuildQueue(true)
                    shouldNotFailBuild(false)
                    parameters('''
TASK=$JIRA_TASKS
SUFFIX=[$JIRA_TASKS][$PACKAGE_VERSION]$SUFFIX
SCHEDULE=$SCHEDULE_LINE
PROFILE=$LOAD_PROFILE
                    ''')
                }
            }
        }
    }
}

loadtest_packages('akita')
loadtest_packages('hound')
loadtest_packages('mbody')
loadtest_packages('mops')
loadtest_packages('retriever')
