cd $WORKSPACE/arcadia

set +ex
TOKEN=$(./ya vault get version sec-01d34s477p8fak79sq374swfqa -o platform.oauth.token)
set -ex

./ya make --checkout mail/wmi-qa/load

cd mail/wmi-qa/load
./deploy_load_env.sh -v "$PACKAGE_VERSION" -t "$TOKEN" -c "[$PACKAGE_VERSION] $SUFFIX" -q "$WORKSPACE/arcadia/ya tool jq" -p "${PROJECT}" -l "${LOGROTATION}"

if
    [[ -n "$SUFFIX" ]];
then
    SUFFIX="[$SUFFIX]";
fi
LOAD_PROFILE=$(cat ${PROJECT}/profile.json | tr '\n' ' ')
SCHEDULE_LINE=$(cat ${PROJECT}/schedule_line.json | tr '\n' ' ')
SCHEDULE_CONST=$(cat ${PROJECT}/schedule_const.json | tr '\n' ' ')

cd $WORKSPACE
echo "LOAD_PROFILE=$LOAD_PROFILE" > profile.properties
echo "SUFFIX=$SUFFIX" >> profile.properties
echo "SCHEDULE_LINE=$SCHEDULE_LINE" >> profile.properties
echo "SCHEDULE_CONST=$SCHEDULE_CONST" >> profile.properties
