multiJob('make-all') {
    displayName('Мультиджоба для сборки и тестирования релизов Webmail')
    description("""Эта джоба сгенерирована автоматически.
            <br/>
            <h2>Время прогона</h2>
            <br/>
            <img src="https://common.jenkins.mail.yandex.net/job/make-all/buildTimeGraph/png" />""")

    label('maildev')

    logRotator(30, 200, 30, 200)

    parameters {
        stringParam('BRANCH', 'svn#trunk', '"asg#my_branch" для asg или "review#review_number#human_name" для ревью или "svn#trunk|revision" для svn')
        stringParam('JIRA_TASKS', '', 'Список задач через пробел, например "WMI-111 DARIA-222 WMI-333"')
        booleanParam('BUILD_AKITA', true, 'Запускать сборку akita')
        booleanParam('BUILD_HOUND', true, 'Запускать сборку hound')
        booleanParam('BUILD_SENDBERNAR', true, 'Запускать сборку sendbernar')
        booleanParam('BUILD_MOPS', true, 'Запускать сборку mops')
        booleanParam('BUILD_MBODY', false, 'Запускать сборку mbody')
        booleanParam('BUILD_RETRIEVER', false, 'Запускать сборку retriever')
        booleanParam('BUILD_SETTINGS', false, 'Запускать сборку settings')
        booleanParam('STRIP_BINARIES', false, 'Отделить отладочные символы')
        booleanParam('LAUNCH_AKITA_LOAD_TEST', false, 'Запускать ли стрельбы по akita')
        booleanParam('LAUNCH_HOUND_LOAD_TEST', false, 'Запускать ли стрельбы по хаунду')
        booleanParam('LAUNCH_MBODY_LOAD_TEST', false, 'Запускать ли стрельбы по mbody')
        booleanParam('LAUNCH_MOPS_LOAD_TEST', false, 'Запускать ли стрельбы по mops')
        booleanParam('LAUNCH_RETRIEVER_LOAD_TEST', false, 'Запускать ли стрельбы по retriever')
    }

    concurrentBuild(true)

    wrappers {
        timestamps()
        preBuildCleanup()
        colorizeOutput('xterm')
        buildName('${ENV,var="BRANCH"}')
    }

    steps {
        shell(readFileFromWorkspace('arcadia/mail/jenkins_groovy/yamail-wmi-jobs/parse_build_properties.sh'))
        shell(readFileFromWorkspace('arcadia/mail/jenkins_groovy/yamail-wmi-jobs/parse_make_all_packages.sh'))
        environmentVariables {
            propertiesFile('build.properties')
        }

        buildDescription('', '$PACKAGE_VERSION')

        phase('BUILD') {
            phaseJob('build-arcadia-packages') {
                parameters {
                    propertiesFile('build.properties')
                }
            }
        }

        phase('TEST', 'SUCCESSFUL') {
            phaseJob('test-webmail-packages') {
                parameters {
                    propertiesFile('build.properties')
                }
            }
            phaseJob('loadtest-akita-packages') {
                killPhaseCondition('NEVER')
                parameters {
                    propertiesFile('build.properties')
                    currentBuild()
                    predefinedProp('LOGROTATION', 'true')
                }
                configure { phaseJobConfig ->
                    phaseJobConfig / enableCondition << 'true'
                    phaseJobConfig / condition << '${LAUNCH_AKITA_LOAD_TEST}'
                }
            }
            phaseJob('loadtest-hound-packages') {
                killPhaseCondition('NEVER')
                parameters {
                    propertiesFile('build.properties')
                    currentBuild()
                    predefinedProp('LOGROTATION', 'true')
                }
                configure { phaseJobConfig ->
                    phaseJobConfig / enableCondition << 'true'
                    phaseJobConfig / condition << '${LAUNCH_HOUND_LOAD_TEST}'
                }
            }
            phaseJob('loadtest-mbody-packages') {
                killPhaseCondition('NEVER')
                parameters {
                    propertiesFile('build.properties')
                    currentBuild()
                }
                configure { phaseJobConfig ->
                    phaseJobConfig / enableCondition << 'true'
                    phaseJobConfig / condition << '${LAUNCH_MBODY_LOAD_TEST}'
                }
            }
            phaseJob('loadtest-mops-packages') {
                killPhaseCondition('NEVER')
                parameters {
                    propertiesFile('build.properties')
                    currentBuild()
                    predefinedProp('LOGROTATION', 'true')
                }
                configure { phaseJobConfig ->
                    phaseJobConfig / enableCondition << 'true'
                    phaseJobConfig / condition << '${LAUNCH_MOPS_LOAD_TEST}'
                }
            }
            phaseJob('loadtest-retriever-packages') {
                killPhaseCondition('NEVER')
                parameters {
                    propertiesFile('build.properties')
                    currentBuild()
                }
                configure { phaseJobConfig ->
                    phaseJobConfig / enableCondition << 'true'
                    phaseJobConfig / condition << '${LAUNCH_RETRIEVER_LOAD_TEST}'
                }
            }
        }
    }
}
