def make_project_job(name, buildOnly) {
    multiJob('make-'+name) {
        displayName('Мультиджоба для сборки и тестирования '+name+'\'а')
        description("""Эта джоба сгенерирована автоматически.
            <br/>
            <h2>Время прогона</h2>
            <br/>
            <img src="https://common.jenkins.mail.yandex.net/job/make-'+name+'/buildTimeGraph/png" />""")

        label('maildev')

        logRotator(30, 200, 30, 200)

        parameters {
            stringParam('BRANCH', 'svn#trunk', '"asg#my_branch" для asg или "review#review_number#human_name" для ревью или "svn#trunk|revision" для svn')
            stringParam('JIRA_TASKS', '', 'Список задач через пробел, например "WMI-111 DARIA-222 WMI-333"')
            booleanParam('STRIP_BINARIES', false, 'Отделить отладочные символы')
            booleanParam('RUN_ARCADIA_TEST', true, 'Запускать ли тесты из аркадии')
        }

        concurrentBuild(true)

        wrappers {
            timestamps()
            preBuildCleanup()
            colorizeOutput('xterm')
            buildName('${ENV,var="BRANCH"}')
        }

        steps {
            shell(readFileFromWorkspace('arcadia/mail/jenkins_groovy/yamail-wmi-jobs/parse_build_properties.sh'))
            environmentVariables {
                propertiesFile('build.properties')
            }

            buildDescription('', '$PACKAGE_VERSION')

            phase('BUILD') {
                phaseJob('build-arcadia-packages') {
                    parameters {
                        propertiesFile('build.properties')
                        predefinedProp('PROJECTS', name)
                    }
                }
            }

            if (!buildOnly) {
                phase('INSTALL') {
                    phaseJob('launch-webmail-containers') {
                        parameters {
                            propertiesFile('build.properties')
                            predefinedProp('PROJECTS', name)
                        }
                    }
                }

                copyArtifacts('launch-webmail-containers') {
                    buildSelector {
                        latestSuccessful(true)
                    }
                }

                environmentVariables {
                    propertiesFile('hosts.props')
                }

                phase('TEST') {
                    phaseJob('test-with-aqua-'+name+'-test') {
                        killPhaseCondition('NEVER')
                        parameters {
                            currentBuild()
                            propertiesFile('hosts.props')
                        }
                    }
                }
            }
        }
    }
}

make_project_job('barbet', false)
make_project_job('spaniel', false)
make_project_job('catdog', true)
make_project_job('doberman', true)
make_project_job('york', true)
