freeStyleJob('ozo_sync') {
    description("""
Cинхронизация https://github.com/yandex/ozo в аркадию
<br/>
Эта джоба сгенерирована автоматически. <br/>
Подробности смотреть в <a href=${JOB_URL}>Seed Job</a>
<br/>
<br/>
<h2>Время выполнения</h2>
<br/>
<img src="buildTimeGraph/png" /><br/>""")

    logRotator(30, 200)
    label('maildev')

    parameters {
        booleanParam('OVERWRITE_ARCADIA_CHANGES', false, 'Затирать изменения в аркадии')
        stringParam('SOURCE_BRANCH', 'origin/master', 'Branch/Commit-Id для синхронизации (лучше ни чего не менять и синхронизировать master)')
    }

    triggers {
        cron('H 3 * * *')
    }

    wrappers {
        timestamps()
        preBuildCleanup()
        colorizeOutput('xterm')
        sshAgent('robot-gerrit-ssh-key')
    }

    steps {
        shell(readFileFromWorkspace('arcadia/mail/jenkins_groovy/yamail-wmi-jobs/ozo_sync.sh'))
    }

    publishers {
        wsCleanup {
            includePattern('*')
            deleteDirectories(true)
            setFailBuild(false)
        }
    }
}
