freeStyleJob('remove-old-temp-environments') {
    description('''
Удаляет все окружения в выбранном приложении
<br/>
Эта джоба сгенерирована автоматически. <br/>
<img src="https://common.jenkins.mail.yandex.net/job/remove-old-temp-environments/buildTimeGraph/png" />
<br/>
    ''')

    label('maildev')
    logRotator(30, 200, 30, 200)
    concurrentBuild()

    parameters {
        stringParam('APPLICATION', 'mail.wmi-qa', 'Приложение с временными окружениями')
        stringParam('VCS', 'svn')
        stringParam('BRANCH', 'trunk')
    }

    wrappers {
        timestamps()
        colorizeOutput('xterm')
        sshAgent('robot-gerrit-ssh-key')
        preBuildCleanup()

        timeout {
            absolute(15)
        }
    }

    steps {
        shell(readFileFromWorkspace('arcadia/mail/jenkins_groovy/yamail-wmi-jobs/clone_arcadia.sh'))
        shell(readFileFromWorkspace('arcadia/mail/jenkins_groovy/yamail-wmi-jobs/remove_old_temp_environments.sh'))
    }
}

multiJob('remove-old-wmiqa-environments') {
    description('''
Очищает mail/wmi-qa
<br/>
Эта джоба сгенерирована автоматически. <br/>
<img src="https://common.jenkins.mail.yandex.net/job/remove-old-wmiqa-environments/buildTimeGraph/png" />
<br/>
    ''')

    label('maildev')
    logRotator(30, 200, 30, 200)

    environmentVariables {
        env('APPLICATION', 'mail.wmi-qa')
    }

    triggers {
        cron('0 4 * * 1')
    }

    wrappers {
        timestamps()
        preBuildCleanup()
        colorizeOutput('xterm')
    }

    steps {
        phase('WMI-QA') {
            phaseJob('remove-old-temp-environments') {
                killPhaseCondition('NEVER')
                parameters {
                    currentBuild()
                }
            }
        }
    }

    publishers {
        mailer('webmail-team@yandex-team.ru')

        retryBuild {
            rerunIfUnstable()
            fixedDelay(5)
            retryLimit(4)
        }
    }
}
