#!/bin/bash

cd $WORKSPACE/arcadia
set +ex
TOKEN=$(./ya vault get version sec-01d34s477p8fak79sq374swfqa -o platform.oauth.token)
set -ex

AUTH="Authorization: OAuth $TOKEN"


while true; do
    ENVIRONMENTS=(`curl -s -k -H "$AUTH" "https://platform.yandex-team.ru/api/v1/project/mail" | jq -r ".applications[] | select(.objectId == \"$APPLICATION\") | .environments[].objectId"`)

    NUM_ENVS_TO_DELETE=${#ENVIRONMENTS[@]}

    if [ $NUM_ENVS_TO_DELETE -le 0 ]; then
        exit 0;
    fi

    for NAME in "${ENVIRONMENTS[@]}"; do
        curl -X DELETE -v --fail -H "$AUTH" "https://platform.yandex-team.ru/api/v1/environment/stable/$NAME"
    done

    while [ $NUM_ENVS_TO_DELETE -gt 0 ]; do
        for NAME in "${ENVIRONMENTS[@]}"; do
            echo "$NAME"

            RESULT=`curl -s -w "\n%{http_code}" -H "$AUTH" "https://platform.yandex-team.ru/api/v1/environment/status/$NAME"`
            STATUS=`echo "$RESULT" | tail -n1`
            
            if [ "$STATUS" = "404" ]; then
                NUM_ENVS_TO_DELETE=$(( $NUM_ENVS_TO_DELETE - 1 ))
            elif [ "$STATUS" = "200" ]; then 
                echo `echo "$RESULT" | head -n1`;
            else
                echo `echo "$RESULT" | head -n1`;
                exit 1;
            fi
        done
        sleep 10;
    done
done
