job('verstka_socialavatars-static-job') {
    logRotator(30, 30, 30, 30)
    label('maildev')

    parameters {
        stringParam('VCS', 'svn')
        stringParam('BRANCH', 'trunk')
    }

    wrappers {
        timestamps()
        colorizeOutput('xterm')
        preBuildCleanup()
        sshAgent('robot-gerrit-ssh-key')

        preBuildCleanup()

        credentialsBinding {
            sshUserPrivateKey {
                // Name of an environment variable to be set to the temporary path of the SSH key file during the build.
                keyFileVariable('GPG_KEY')
                // Credentials of an appropriate type to be set to the variable.
                credentialsId('robot-gerrit-secret-pgp-key')
            }
        }
    }

    steps {
        shell(readFileFromWorkspace('arcadia/mail/jenkins_groovy/yamail-wmi-jobs/clone_arcadia.sh'))
        shell('''
            cd arcadia && ./ya make --checkout yandex360/frontend/packages/socialavatars-static
            cd yandex360/frontend/packages/socialavatars-static

            gpg --import "${GPG_KEY}" || true
            gpg --list-keys
            make deb && make deb-publish
        ''')
    }
}
