import argparse
import os
import mail.juggler.lib.checks as checks

TOKEN_NAME = "JUGGLER_OAUTH_TOKEN"


def main():
    parser = argparse.ArgumentParser(description="Generate juggler checks")
    parser.add_argument(
        "-p", "--projects",
        nargs="+",
        help="List of projects to regenerate checks",
        required=True
    )
    parser.add_argument(
        "-t", "--token",
        help="juggler oauth token (by default env var {})".format(TOKEN_NAME),
        default=os.environ.get(TOKEN_NAME)
    )
    args = parser.parse_args()

    checks.gen_checks(args.projects, args.token)
    print "juggler checks generated successfully"


if __name__ == "__main__":
    main()
