import itertools
import importlib
from juggler_sdk import JugglerApi


def gen_checks(projects, oauth_token):
    checks = ()
    for project in projects:
        module = importlib.import_module("." + project, "mail.juggler.lib")
        checks = itertools.chain(
            checks,
            module.get_checks(),
        )
    with JugglerApi("http://juggler-api.search.yandex.net", mark="mail_generated", oauth_token=oauth_token) as api:
        for check in checks:
            api.upsert_check(check)
