package ru.yandex.kitsune.config;

import java.util.Objects;
import java.util.Set;

import javax.annotation.Nonnull;

import ru.yandex.http.config.AbstractHttpHostConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractProxyHttpHostConfigBuilder<T extends AbstractProxyHttpHostConfigBuilder<T>>
        extends AbstractHttpHostConfigBuilder<T>
        implements ProxyHttpHostConfig {
    @Nonnull
    private Set<String> proxyPatterns;

    private double probability;

    protected AbstractProxyHttpHostConfigBuilder(final ProxyHttpHostConfig config) {
        super(config);
        proxyPatterns = config.proxyPatterns();
        probability = config.probability();
    }

    protected AbstractProxyHttpHostConfigBuilder(
            final IniConfig config,
            final ProxyHttpHostConfig defaults)
            throws ConfigException {
        super(config, defaults);
        proxyPatterns = PROXY_PATTERNS.extract(config, defaults.proxyPatterns());
        probability = config.getDouble("probability", defaults.probability());
    }

    @Nonnull
    @Override
    public Set<String> proxyPatterns() {
        return proxyPatterns;
    }

    public void path(@Nonnull Set<String> proxyPatterns) {
        this.proxyPatterns = Objects.requireNonNull(proxyPatterns);
    }

    @Override
    public double probability() {
        return probability;
    }

    public void path(double probability) {
        this.probability = probability;
    }
}

