package ru.yandex.kitsune.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import javax.annotation.Nonnull;

import ru.yandex.collection.Pattern;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableKitsuneConfig
        extends ImmutableHttpProxyConfig
        implements KitsuneConfig {
    @Nonnull
    private final ImmutableHttpHostConfig head;

    @Nonnull
    private final Map<String, ImmutableProxyHttpHostConfig> tails;

    @Nonnull
    private final Map<String, Pattern<RequestInfo>> proxyPatterns;

    public ImmutableKitsuneConfig(final KitsuneConfig config)
            throws ConfigException {
        super(config);

        head = new ImmutableHttpHostConfig(config.head());

        if (!config.tails().isEmpty()) {
            tails = new HashMap<>(config.tails().size());

            for (var entry : config.tails().entrySet()) {
                tails.put(entry.getKey(), new ImmutableProxyHttpHostConfig(entry.getValue()));
            }
        } else {
            tails = Collections.emptyMap();
        }

        proxyPatterns = config.proxyPatterns();
    }

    @Override
    @Nonnull
    public ImmutableHttpHostConfig head() {
        return head;
    }

    @Override
    @Nonnull
    public Map<String, ImmutableProxyHttpHostConfig> tails() {
        return tails;
    }

    @Override
    @Nonnull
    public Map<String, Pattern<RequestInfo>> proxyPatterns() {
        return proxyPatterns;
    }
}

