package ru.yandex.kitsune.config;

import java.util.Set;

import javax.annotation.Nonnull;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableProxyHttpHostConfig
        extends ImmutableHttpHostConfig
        implements ProxyHttpHostConfig {
    @Nonnull
    private final Set<String> proxyPatterns;

    private final double probability;

    public ImmutableProxyHttpHostConfig(final ProxyHttpHostConfig config)
            throws ConfigException {
        super(config);

        proxyPatterns = PROXY_PATTERNS.validate(config.proxyPatterns());
        probability = config.probability();
    }

    @Nonnull
    @Override
    public Set<String> proxyPatterns() {
        return proxyPatterns;
    }

    @Override
    public double probability() {
        return probability;
    }
}

