package ru.yandex.kitsune.config;

import java.io.IOException;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class KitsuneConfigBuilder
        extends AbstractKitsuneConfigBuilder<KitsuneConfigBuilder> {
    public KitsuneConfigBuilder() {
        super(KitsuneConfigDefaults.INSTANCE);
    }

    public KitsuneConfigBuilder(final KitsuneConfig config) {
        super(config);
    }

    public KitsuneConfigBuilder(final IniConfig config)
            throws ConfigException, IOException {
        super(config, KitsuneConfigDefaults.INSTANCE);
    }

    public KitsuneConfigBuilder(
            final IniConfig config,
            final KitsuneConfig defaults)
            throws ConfigException, IOException {
        super(config, defaults);
    }

    @Override
    public KitsuneConfigBuilder self() {
        return this;
    }

    public ImmutableKitsuneConfig build() throws ConfigException {
        return new ImmutableKitsuneConfig(this);
    }
}

