package ru.yandex.kitsune.config;

import java.util.HashSet;
import java.util.Set;

import javax.annotation.Nonnull;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.CollectionValidator;
import ru.yandex.parser.string.NonEmptyCollectionValidator;
import ru.yandex.parser.string.NonEmptyValidator;

public interface ProxyHttpHostConfig extends HttpHostConfig {

    ParameterConfig<Set<String>> PROXY_PATTERNS = new ParameterConfig<>(
            "proxy-patterns",
            new CollectionParser<>(
                    NonEmptyValidator.TRIMMED,
                    HashSet::new),
            new CollectionValidator<String, Set<String>>(
                    NonEmptyValidator.INSTANCE)
                    .andThen(NonEmptyCollectionValidator.instance())
                    .andThen(HashSet::new));

    @Nonnull
    Set<String> proxyPatterns();

    double probability();
}

