package ru.yandex.kitsune.config;

import java.io.IOException;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class ProxyHttpHostConfigBuilder
        extends AbstractProxyHttpHostConfigBuilder<ProxyHttpHostConfigBuilder> {
    public ProxyHttpHostConfigBuilder() {
        super(ProxyHttpHostConfigDefaults.INSTANCE);
    }

    public ProxyHttpHostConfigBuilder(final ProxyHttpHostConfig config) {
        super(config);
    }

    public ProxyHttpHostConfigBuilder(final IniConfig config)
            throws ConfigException, IOException {
        super(config, ProxyHttpHostConfigDefaults.INSTANCE);
    }

    public ProxyHttpHostConfigBuilder(
            final IniConfig config,
            final ProxyHttpHostConfig defaults)
            throws ConfigException, IOException {
        super(config, defaults);
    }

    @Override
    public ProxyHttpHostConfigBuilder self() {
        return this;
    }

    public ImmutableProxyHttpHostConfig build() throws ConfigException {
        return new ImmutableProxyHttpHostConfig(this);
    }
}

