/** @file blackbox2.xs */

#ifdef __cplusplus
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include "ppport.h"
#ifdef __cplusplus
}
#endif

#undef do_open
#undef do_close

#include "yandex/blackbox/blackbox2.h"


using namespace bb;

struct DBFieldsIterator {
        DBFieldsIterator(DBFields *f) : flds(f), it(f->begin()) {}
        DBFields *flds;
        DBFields::const_iterator it;
};

typedef EmailList::Item EmailList__Item;
typedef AliasList::Item AliasList__Item;
typedef AliasList::Item::Type AliasList__Item__Type;
typedef MailHostsList::Item MailHostsList__Item;
typedef BruteforcePolicy::Mode BruteforcePolicy__Mode;
typedef SessionKind::Kind SessionKind__Kind;

typedef LoginResp::Status LoginResp__Status;
typedef LoginResp::AccountStatus LoginResp__AccountStatus;
typedef LoginResp::PasswdStatus LoginResp__PasswdStatus;
typedef SessionResp::Status SessionResp__Status;
typedef HostResp::Status HostResp__Status;

// --------------------------- Options --------------------------
MODULE = blackbox2        PACKAGE = blackbox2::Option
PROTOTYPES: ENABLE

Option*
new(CLASS, key, val)
    char *CLASS
    char *key
    char *val
CODE:
    try {
        RETVAL = new Option(key,val);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    };
OUTPUT:
    RETVAL

void
DESTROY(self)
    Option *self
CODE:
    delete self;

SV*
key(self)
    Option *self
CODE:
    RETVAL = newSVpvn(self->key().c_str(), self->key().size());
OUTPUT:
    RETVAL

SV*
val(self)
    Option *self
CODE:
    RETVAL = newSVpvn(self->val().c_str(), self->val().size());
OUTPUT:
    RETVAL

Option*
Regname(CLASS)
    char *CLASS
CODE:
    RETVAL = new Option(optRegname);
OUTPUT:
    RETVAL

Option*
GetSocialAliases(CLASS)
    char *CLASS
CODE:
    RETVAL = new Option(optGetSocialAliases);
OUTPUT:
    RETVAL

Option*
GetAllAliases(CLASS)
    char *CLASS
CODE:
    RETVAL = new Option(optGetAllAliases);
OUTPUT:
    RETVAL

Option*
GetAllEmails(CLASS)
    char *CLASS
CODE:
    RETVAL = new Option(optGetAllEmails);
OUTPUT:
    RETVAL

Option*
GetYandexEmails(CLASS)
    char *CLASS
CODE:
    RETVAL = new Option(optGetYandexEmails);
OUTPUT:
    RETVAL

Option*
GetDefaultEmail(CLASS)
    char *CLASS
CODE:
    RETVAL = new Option(optGetDefaultEmail);
OUTPUT:
    RETVAL

Option*
Version2(CLASS)
    char *CLASS
CODE:
    RETVAL = new Option(optVersion2);
OUTPUT:
    RETVAL

Option*
AuthId(CLASS)
    char *CLASS
CODE:
    RETVAL = new Option(optAuthId);
OUTPUT:
    RETVAL

Option*
FullInfo(CLASS)
    char *CLASS
CODE:
    RETVAL = new Option(optFullInfo);
OUTPUT:
    RETVAL

Option*
Multisession(CLASS)
    char *CLASS
CODE:
    RETVAL = new Option(optMultisession);
OUTPUT:
    RETVAL


MODULE = blackbox2        PACKAGE = blackbox2::Options
PROTOTYPES: ENABLE

Options*
new(CLASS)
    char *CLASS
CODE:
    try {
        RETVAL = new Options();
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    };
OUTPUT:
    RETVAL

void
DESTROY(self)
    Options *self
CODE:
    delete self;

void
add(self, name, value)
    Options *self
    char *name
    char *value
CODE:
    *self << Option(name, value);

void
add_opt(self, opt)
    Options *self
    Option *opt
CODE:
    *self << *opt;

void
add_fields(self, fields)
    Options *self
    DBFields *fields
CODE:
    *self << *fields;

void
add_aliases(self, aliases)
    Options *self
    OptAliases *aliases
CODE:
    *self << *aliases;

void
add_attributes(self, attrs)
    Options *self
    Attributes *attrs
CODE:
    *self << *attrs;

MODULE = blackbox2        PACKAGE = blackbox2::OptTestEmail
PROTOTYPES: ENABLE

OptTestEmail*
new(CLASS, addr)
    char *CLASS
    char *addr
CODE:
    try {
        RETVAL = new OptTestEmail(addr);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    };
OUTPUT:
    RETVAL

void
DESTROY(self)
    OptTestEmail *self
CODE:
    delete self;

void
format(self, opts)
    OptTestEmail *self
    Options *opts
CODE:
    self->format(*opts);

# --------------------------- DBFields iterator ---------------
MODULE = blackbox2        PACKAGE = blackbox2::DBFieldsIterator
PROTOTYPES: ENABLE

DBFieldsIterator*
new(CLASS, f)
    char *CLASS;
    DBFields *f;
CODE:
    try {
        RETVAL = new DBFieldsIterator(f);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    };
OUTPUT:
    RETVAL

void
DESTROY(self)
    DBFieldsIterator *self
CODE:
    delete self;

HV*
getNext(self)
    DBFieldsIterator *self
CODE:
    if (self->flds->end() == self->it) {
            XSRETURN_UNDEF;
    }
    HV* ret_values = newHV();
    hv_store(ret_values, "key", 3, newSVpv(self->it->first.c_str(), self->it->first.size()), 0);
    hv_store(ret_values, "val", 3, newSVpv(self->it->second.c_str(), self->it->second.size()), 0);
    RETVAL = ret_values;
    sv_2mortal((SV*)RETVAL);
    ++(self->it);
OUTPUT:
    RETVAL

void
toBegin(self)
    DBFieldsIterator *self
CODE:
    self->it = self->flds->begin();


# --------------------------- DBFields ------------------------
MODULE = blackbox2        PACKAGE = blackbox2::DBFields
PROTOTYPES: ENABLE

DBFields*
new(CLASS)
    char *CLASS;
CODE:
    try {
        RETVAL = new DBFields();
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    };
OUTPUT:
    RETVAL

void
DESTROY(self)
    DBFields *self
CODE:
    delete self;

bool
empty(self)
    DBFields *self
CODE:
    RETVAL = self->empty();
OUTPUT:
    RETVAL

int
size(self)
    DBFields *self
CODE:
    RETVAL = self->size();
OUTPUT:
    RETVAL

void
clear(self)
    DBFields *self
CODE:
    self->clear();

void
clearValues(self)
    DBFields *self
CODE:
    self->clearValues();

SV*
get(self, field)
    DBFields *self
    char *field
CODE:
    RETVAL = newSVpvn(self->get(field).c_str(), self->get(field).size());
OUTPUT:
    RETVAL

void
add(self, field)
    DBFields *self
    char *field
CODE:
    *self << field ;

void
readResponse(self, response)
    DBFields *self
    Response *response
CODE:
    self->readResponse(response);

Options*
getOptions(self)
    DBFields* self
CODE:
    const char* CLASS = "blackbox2::Options";
    RETVAL = new Options(*self);
OUTPUT:
    RETVAL


# --------------------------- OptAliases ----------------------
MODULE = blackbox2        PACKAGE = blackbox2::OptAliases
PROTOTYPES: ENABLE

OptAliases*
new(CLASS)
    char *CLASS;
CODE:
    try {
        RETVAL = new OptAliases();
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    };
OUTPUT:
    RETVAL

void
DESTROY(self)
    OptAliases *self
CODE:
    delete self;

bool
empty(self)
    OptAliases *self
CODE:
    RETVAL = self->empty();
OUTPUT:
    RETVAL

int
size(self)
    OptAliases *self
CODE:
    RETVAL = self->size();
OUTPUT:
    RETVAL

void
add(self, alias)
    OptAliases *self
    char *alias
CODE:
    *self << alias ;

Options*
getOptions(self)
    OptAliases* self
CODE:
    const char* CLASS = "blackbox2::Options";
    RETVAL = new Options(*self);
OUTPUT:
    RETVAL

# --------------------------- Attributes ----------------------
MODULE = blackbox2        PACKAGE = blackbox2::Attributes
PROTOTYPES: ENABLE

Attributes*
new(CLASS)
    char *CLASS;
CODE:
    try {
        RETVAL = new Attributes();
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    };
OUTPUT:
    RETVAL

void
DESTROY(self)
    Attributes *self
CODE:
    delete self;

bool
empty(self)
    Attributes *self
CODE:
    RETVAL = self->empty();
OUTPUT:
    RETVAL

int
size(self)
    Attributes *self
CODE:
    RETVAL = self->size();
OUTPUT:
    RETVAL

void
clear(self)
    Attributes *self
CODE:
    self->clear();

void
clearValues(self)
    Attributes *self
CODE:
    self->clearValues();

SV*
get(self, field)
    Attributes *self
    char *field
CODE:
    RETVAL = newSVpvn(self->get(field).c_str(), self->get(field).size());
OUTPUT:
    RETVAL

void
add(self, field)
    Attributes *self
    char *field
CODE:
    *self << field ;

void
readResponse(self, response)
    Attributes *self
    Response *response
CODE:
    self->readResponse(response);

Options*
getOptions(self)
    Attributes* self
CODE:
    const char* CLASS = "blackbox2::Options";
    RETVAL = new Options(*self);
OUTPUT:
    RETVAL


#                            Requests

# --------------------------- LoginSid -------------------------
MODULE = blackbox2        PACKAGE = blackbox2::LoginSid
PROTOTYPES: ENABLE

LoginSid*
new(CLASS, login, sid)
    char *CLASS
    char *login
    char *sid
CODE:
    try {
        RETVAL = new LoginSid(login, sid);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    LoginSid *self
CODE:
    delete self;

# --------------------------- SuidSid --------------------------
MODULE = blackbox2        PACKAGE = blackbox2::SuidSid
PROTOTYPES: ENABLE

SuidSid*
new(CLASS, suid, sid)
    char *CLASS
    char *suid
    char *sid
CODE:
    try {
        RETVAL = new SuidSid(suid, sid);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    SuidSid *self
CODE:
    delete self;

# --------------------------- InfoRequest -------------------------
MODULE = blackbox2        PACKAGE = blackbox2
PROTOTYPES: ENABLE

SV*
InfoRequest_Uid(uid, userip, options)
    char *uid
    char *userip
    Options *options
INIT:
    std::string value;
CODE:
    value = InfoRequest(uid, userip, *options);
    RETVAL = newSVpvn(value.c_str(), value.size());
OUTPUT:
    RETVAL

SV*
InfoRequest_LSid(loginsid, userip, options)
    LoginSid *loginsid
    char *userip
    Options *options
INIT:
    std::string value;
CODE:
    value = InfoRequest(*loginsid, userip, *options);
    RETVAL = newSVpvn(value.c_str(), value.size());
OUTPUT:
    RETVAL

SV*
InfoRequest_SSid(suidsid, userip, options)
    SuidSid *suidsid
    char *userip
    Options *options
INIT:
    std::string value;
CODE:
    value = InfoRequest(*suidsid, userip, *options);
    RETVAL = newSVpvn(value.c_str(), value.size());
OUTPUT:
    RETVAL

SV*
InfoRequest_Bulk(uids, userip, options)
    AV* uids
    char *userip
    Options *options
INIT:
    std::string value;
    std::vector<std::string> uids_vec;
    SV ** val;
    I32 len;
    STRLEN slen;
    char* sval;
CODE:
    bool ok=true;
    len = av_len(uids) + 1;
    for(I32 i = 0; i < len; ++i) {
            val = av_fetch(uids, i, 0);
            if (NULL == val) {
                ok = false;
                break;
            }
            sval = SvPV(*val,slen);
            if (sval < 0) {
                ok = false;
                break;
            }
            uids_vec.push_back(std::string(sval,slen));
        }

    if (ok) {
        value = InfoRequest(uids_vec, userip, *options);
        RETVAL = newSVpvn(value.c_str(), value.size());
    }
    else RETVAL = NULL;
OUTPUT:
    RETVAL

# --------------------------- LoginRequest -------------------------
HV*
LoginRequest(loginsid, passwd, authtype, userip, options)
    LoginSid *loginsid
    char *passwd
    char *authtype
    char *userip
    Options *options
INIT:
    LoginReqData data;
CODE:
    data = LoginRequest(*loginsid, passwd, authtype, userip, *options);
    RETVAL = (HV *)sv_2mortal((SV *)newHV());

    hv_store(RETVAL, "uri", 3, newSVpvn(data.uri_.c_str(), data.uri_.size()), 0);
    hv_store(RETVAL, "postData", 8, newSVpvn(data.postData_.c_str(), data.postData_.size()), 0);
OUTPUT:
    RETVAL

HV*
LoginRequest_Uid(uid, passwd, authtype, userip, options)
    char *uid
    char *passwd
    char *authtype
    char *userip
    Options *options
INIT:
    LoginReqData data;
CODE:
    data = LoginRequestUid(uid, passwd, authtype, userip, *options);
    RETVAL = (HV *)sv_2mortal((SV *)newHV());

    hv_store(RETVAL, "uri", 3, newSVpvn(data.uri_.c_str(), data.uri_.size()), 0);
    hv_store(RETVAL, "postData", 8, newSVpvn(data.postData_.c_str(), data.postData_.size()), 0);
OUTPUT:
    RETVAL

# --------------------------- SessionIDRequest ---------------------
SV*
SessionIDRequest(sessionid, hostname, userip, options)
    char *sessionid
    char *hostname
    char *userip
    Options *options
INIT:
    std::string value;
CODE:
    value = SessionIDRequest(sessionid, hostname, userip, *options);
    RETVAL = newSVpvn(value.c_str(), value.size());
OUTPUT:
    RETVAL

# --------------------------- OAuthRequest -------------------------
SV*
OAuthRequest(token, userip, options)
    char *token
    char *userip
    Options *options
INIT:
    std::string value;
CODE:
    value = OAuthRequest(token, userip, *options);
    RETVAL = newSVpvn(value.c_str(), value.size());
OUTPUT:
    RETVAL

# --------------------------- MailHostRequest ----------------------
SV*
MailHostCreateRequest(scope, dbid, priority, mx)
    char *scope
    char *dbid
    char *priority
    char *mx
INIT:
    std::string value;
CODE:
    value = MailHostCreateRequest(scope, dbid, priority, mx);
    RETVAL = newSVpvn(value.c_str(), value.size());
OUTPUT:
    RETVAL

SV*
MailHostDeleteRequest(scope, dbid)
    char *scope
    char *dbid
INIT:
    std::string value;
CODE:
    value = MailHostDeleteRequest(scope, dbid);
    RETVAL = newSVpvn(value.c_str(), value.size());
OUTPUT:
    RETVAL

SV*
MailHostAssignRequest(scope, suid, dbid)
    char *scope
    char *suid
    char *dbid
INIT:
    std::string value;
CODE:
    value = MailHostAssignRequest(scope, suid, dbid);
    RETVAL = newSVpvn(value.c_str(), value.size());
OUTPUT:
    RETVAL

SV*
MailHostSetPriorityRequest(scope, dbid, priority)
    char *scope
    char *dbid
    char *priority
INIT:
    std::string value;
CODE:
    value = MailHostSetPriorityRequest(scope, dbid, priority);
    RETVAL = newSVpvn(value.c_str(), value.size());
OUTPUT:
    RETVAL

SV*
MailHostFindRequest(scope, priority)
    char *scope
    char *priority
INIT:
    std::string value;
CODE:
    value = MailHostFindRequest(scope, priority);
    RETVAL = newSVpvn(value.c_str(), value.size());
OUTPUT:
    RETVAL

# --------------------------- PwdQualityRequest -------------------
SV*
PwdQualityRequest(sessionid, hostname)
    char *sessionid
    char *hostname
INIT:
    std::string value;
CODE:
    value = PwdQualityRequest(sessionid, hostname);
    RETVAL = newSVpvn(value.c_str(), value.size());
OUTPUT:
    RETVAL

# --------------------------- Response --------------------------
MODULE = blackbox2        PACKAGE = blackbox2::Response
PROTOTYPES: ENABLE

Response*
new(CLASS, resp)
    char *CLASS
    char *resp
CODE:
    try {
        RETVAL = InfoResponse(resp).release();
    } catch (const FatalError &e) {
        croak("FatalError: code=%d , %s", e.code(), e.what());
    } catch (const TempError &e) {
        croak("TempError: code=%d, %s", e.code(), e.what());
    } catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    Response *self
CODE:
    delete self;

SV*
message(self)
    Response *self
CODE:
    RETVAL = newSVpvn(self->message().c_str(), self->message().size());
OUTPUT:
    RETVAL

MODULE = blackbox2        PACKAGE = blackbox2::BulkResponse
PROTOTYPES: ENABLE

BulkResponse*
new(CLASS, resp)
    char *CLASS
    char *resp
CODE:
    try {
        RETVAL = InfoResponseBulk(resp).release();
    } catch (const FatalError &e) {
        croak("FatalError: code=%d , %s", e.code(), e.what());
    } catch (const TempError &e) {
        croak("TempError: code=%d, %s", e.code(), e.what());
    } catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    BulkResponse *self
CODE:
    delete self;

SV*
message(self)
    BulkResponse *self
CODE:
    RETVAL = newSVpvn(self->message().c_str(), self->message().size());
OUTPUT:
    RETVAL

int
count(self)
    BulkResponse *self
CODE:
    RETVAL = self->count();
OUTPUT:
    RETVAL

SV*
id(self, i)
    BulkResponse *self
    int i
CODE:
    RETVAL = newSVpvn(self->id(i).c_str(), self->id(i).size());
OUTPUT:
    RETVAL

Response*
user(self, i)
    BulkResponse *self
    int i
CODE:
    const char* CLASS = "blackbox2::BulkResponse";
    RETVAL = self->user(i).release();
OUTPUT:
    RETVAL


MODULE = blackbox2        PACKAGE = blackbox2::LoginResp
PROTOTYPES: ENABLE

LoginResp*
new(CLASS, resp)
    char *CLASS
    char *resp
CODE:
    try {
        RETVAL = LoginResponse(resp).release();
    } catch (const FatalError &e) {
        croak("FatalError: code=%d , %s", e.code(), e.what());
    } catch (const TempError &e) {
        croak("TempError: code=%d, %s", e.code(), e.what());
    } catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    LoginResp *self
CODE:
    delete self;

LoginResp::Status
status(self)
    LoginResp *self
CODE:
    RETVAL = self->status();
OUTPUT:
    RETVAL

LoginResp::AccountStatus
accStatus(self)
    LoginResp *self
CODE:
    RETVAL = self->accStatus();
OUTPUT:
    RETVAL

LoginResp::PasswdStatus
pwdStatus(self)
    LoginResp *self
CODE:
    RETVAL = self->pwdStatus();
OUTPUT:
    RETVAL

SV*
message(self)
    LoginResp *self
CODE:
    RETVAL = newSVpvn(self->message().c_str(), self->message().size());
OUTPUT:
    RETVAL

MODULE = blackbox2        PACKAGE = blackbox2::SessionResp
PROTOTYPES: ENABLE

SessionResp*
new(CLASS, resp)
    char *CLASS
    char *resp
CODE:
    try {
        RETVAL = SessionIDResponse(resp).release();
    } catch (const FatalError &e) {
        croak("FatalError: code=%d , %s", e.code(), e.what());
    } catch (const TempError &e) {
        croak("TempError: code=%d, %s", e.code(), e.what());
    } catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    SessionResp *self
CODE:
    delete self;

SV*
message(self)
    SessionResp *self
CODE:
    RETVAL = newSVpvn(self->message().c_str(), self->message().size());
OUTPUT:
    RETVAL

SessionResp::Status
status(self)
    SessionResp *self
CODE:
    RETVAL = self->status();
OUTPUT:
    RETVAL

bool
isLite(self)
    SessionResp *self
CODE:
    RETVAL = self->isLite();
OUTPUT:
    RETVAL

SV*
age(self)
    SessionResp *self
CODE:
    RETVAL = newSVpvn(self->age().c_str(), self->age().size());
OUTPUT:
    RETVAL

MODULE = blackbox2        PACKAGE = blackbox2::MultiSessionResp
PROTOTYPES: ENABLE

MultiSessionResp*
new(CLASS, resp)
    char *CLASS
    char *resp
CODE:
    try {
        RETVAL = SessionIDResponseMulti(resp).release();
    } catch (const FatalError &e) {
        croak("FatalError: code=%d , %s", e.code(), e.what());
    } catch (const TempError &e) {
        croak("TempError: code=%d, %s", e.code(), e.what());
    } catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    MultiSessionResp *self
CODE:
    delete self;

SV*
message(self)
    MultiSessionResp *self
CODE:
    RETVAL = newSVpvn(self->message().c_str(), self->message().size());
OUTPUT:
    RETVAL

SessionResp::Status
status(self)
    MultiSessionResp *self
CODE:
    RETVAL = self->status();
OUTPUT:
    RETVAL

SV*
age(self)
    MultiSessionResp *self
CODE:
    RETVAL = newSVpvn(self->age().c_str(), self->age().size());
OUTPUT:
    RETVAL

SV*
defaultUid(self)
    MultiSessionResp *self
CODE:
    RETVAL = newSVpvn(self->defaultUid().c_str(), self->defaultUid().size());
OUTPUT:
    RETVAL

int
count(self)
    MultiSessionResp *self
CODE:
    RETVAL = self->count();
OUTPUT:
    RETVAL

SV*
id(self, i)
    MultiSessionResp *self
    int i
CODE:
    RETVAL = newSVpvn(self->id(i).c_str(), self->id(i).size());
OUTPUT:
    RETVAL

SessionResp*
user(self, i)
    MultiSessionResp *self
    int i
CODE:
    const char* CLASS = "blackbox2::SessionResp";
    RETVAL = self->user(i).release();
OUTPUT:
    RETVAL

MODULE = blackbox2        PACKAGE = blackbox2::HostResp
PROTOTYPES: ENABLE

HostResp*
new(CLASS, resp)
    char *CLASS
    char *resp
CODE:
    try {
        RETVAL = MailHostResponse(resp).release();
    } catch (const FatalError &e) {
        croak("FatalError: code=%d , %s", e.code(), e.what());
    } catch (const TempError &e) {
        croak("TempError: code=%d, %s", e.code(), e.what());
    } catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    HostResp *self
CODE:
    delete self;

SV*
message(self)
    HostResp *self
CODE:
    RETVAL = newSVpvn(self->message().c_str(), self->message().size());
OUTPUT:
    RETVAL

HostResp::Status
status(self)
    HostResp *self
CODE:
    RETVAL = self->status();
OUTPUT:
    RETVAL

MODULE = blackbox2        PACKAGE = blackbox2::PwdQualityResp
PROTOTYPES: ENABLE

PwdQualityResp*
new(CLASS, resp)
    char *CLASS
    char *resp
CODE:
    try {
        RETVAL = PwdQualityResponse(resp).release();
    } catch (const FatalError &e) {
        croak("FatalError: code=%d , %s", e.code(), e.what());
    } catch (const TempError &e) {
        croak("TempError: code=%d, %s", e.code(), e.what());
    } catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    PwdQualityResp *self
CODE:
    delete self;

SV*
message(self)
    PwdQualityResp *self
CODE:
    RETVAL = newSVpvn(self->message().c_str(), self->message().size());
OUTPUT:
    RETVAL

#                            Accessors

# --------------------------- Regname ----------------------------
MODULE = blackbox2        PACKAGE = blackbox2::Regname
PROTOTYPES: ENABLE

Regname*
new(CLASS, response)
    char *CLASS
    Response *response
CODE:
    try {
        RETVAL = new Regname(response);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    Regname *self
CODE:
    delete self;

SV*
value(self)
    Regname *self
CODE:
    RETVAL = newSVpvn(self->value().c_str(), self->value().size());
OUTPUT:
    RETVAL

# --------------------------- Uid --------------------------------
MODULE = blackbox2        PACKAGE = blackbox2::Uid
PROTOTYPES: ENABLE

Uid*
new(CLASS, response)
    char *CLASS
    Response *response
CODE:
    try {
        RETVAL = new Uid(response);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    Uid *self
CODE:
    delete self;

SV*
uid(self)
    Uid *self
CODE:
    RETVAL = newSVpvn(self->uid().c_str(), self->uid().size());
OUTPUT:
    RETVAL

bool
hosted(self)
    Uid *self
CODE:
    RETVAL = self->hosted();
OUTPUT:
    RETVAL

# --------------------------- LiteUid ----------------------------
MODULE = blackbox2        PACKAGE = blackbox2::LiteUid
PROTOTYPES: ENABLE

LiteUid*
new(CLASS, response)
    char *CLASS
    Response *response
CODE:
    try {
        RETVAL = new LiteUid(response);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    LiteUid *self
CODE:
    delete self;

SV*
liteUid(self)
    LiteUid *self
CODE:
    RETVAL = newSVpvn(self->liteUid().c_str(), self->liteUid().size());
OUTPUT:
    RETVAL

bool
liteAccount(self)
    LiteUid *self
CODE:
    RETVAL = self->liteAccount();
OUTPUT:
    RETVAL

# --------------------------- PDDUserInfo ------------------------
MODULE = blackbox2        PACKAGE = blackbox2::PDDUserInfo
PROTOTYPES: ENABLE

PDDUserInfo*
new(CLASS, response)
    char *CLASS
    Response *response
CODE:
    try {
        RETVAL = new PDDUserInfo(response);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    PDDUserInfo *self
CODE:
    delete self;

SV*
domId(self)
    PDDUserInfo *self
CODE:
    RETVAL = newSVpvn(self->domId().c_str(), self->domId().size());
OUTPUT:
    RETVAL

SV*
domain(self)
    PDDUserInfo *self
CODE:
    RETVAL = newSVpvn(self->domain().c_str(), self->domain().size());
OUTPUT:
    RETVAL

SV*
mx(self)
    PDDUserInfo *self
CODE:
    RETVAL = newSVpvn(self->mx().c_str(), self->mx().size());
OUTPUT:
    RETVAL

SV*
domEna(self)
    PDDUserInfo *self
CODE:
    RETVAL = newSVpvn(self->domEna().c_str(), self->domEna().size());
OUTPUT:
    RETVAL

SV*
catchAll(self)
    PDDUserInfo *self
CODE:
    RETVAL = newSVpvn(self->catchAll().c_str(), self->catchAll().size());
OUTPUT:
    RETVAL

# --------------------------- KarmaInfo --------------------------
MODULE = blackbox2        PACKAGE = blackbox2::KarmaInfo
PROTOTYPES: ENABLE

KarmaInfo*
new(CLASS, response)
    char *CLASS
    Response *response
CODE:
    try {
        RETVAL = new KarmaInfo(response);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    KarmaInfo *self
CODE:
    delete self;

SV*
karma(self)
    KarmaInfo *self
CODE:
    RETVAL = newSVpvn(self->karma().c_str(), self->karma().size());
OUTPUT:
    RETVAL

SV*
bantime(self)
    KarmaInfo *self
CODE:
    RETVAL = newSVpvn(self->banTime().c_str(), self->banTime().size());
OUTPUT:
    RETVAL

SV*
karmaStatus(self)
    KarmaInfo *self
CODE:
    RETVAL = newSVpvn(self->karmaStatus().c_str(), self->karmaStatus().size());
OUTPUT:
    RETVAL

# --------------------------- DisplayNameInfo --------------------
MODULE = blackbox2        PACKAGE = blackbox2::DisplayNameInfo
PROTOTYPES: ENABLE

DisplayNameInfo*
new(CLASS, response)
    char *CLASS
    Response *response
CODE:
    try {
        RETVAL = new DisplayNameInfo(response);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    DisplayNameInfo *self
CODE:
    delete self;

SV*
name(self)
    DisplayNameInfo *self
CODE:
    RETVAL = newSVpvn(self->name().c_str(), self->name().size());
OUTPUT:
    RETVAL

bool
social(self)
    DisplayNameInfo *self
CODE:
    RETVAL = self->social();
OUTPUT:
    RETVAL

SV*
socProfile(self)
    DisplayNameInfo *self
CODE:
    RETVAL = newSVpvn(self->socProfile().c_str(), self->socProfile().size());
OUTPUT:
    RETVAL

SV*
socProvider(self)
    DisplayNameInfo *self
CODE:
    RETVAL = newSVpvn(self->socProvider().c_str(), self->socProvider().size());
OUTPUT:
    RETVAL

SV*
socTarget(self)
    DisplayNameInfo *self
CODE:
    RETVAL = newSVpvn(self->socTarget().c_str(), self->socTarget().size());
OUTPUT:
    RETVAL

SV*
defaultAvatar(self)
    DisplayNameInfo *self
CODE:
    RETVAL = newSVpvn(self->defaultAvatar().c_str(), self->defaultAvatar().size());
OUTPUT:
    RETVAL

# --------------------------- LoginInfo --------------------------
MODULE = blackbox2        PACKAGE = blackbox2::LoginInfo
PROTOTYPES: ENABLE

LoginInfo*
new(CLASS, response)
    char *CLASS
    Response *response
CODE:
    try {
        RETVAL = new LoginInfo(response);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    LoginInfo *self
CODE:
    delete self;

SV*
login(self)
    LoginInfo *self
CODE:
    RETVAL = newSVpvn(self->login().c_str(), self->login().size());
OUTPUT:
    RETVAL

bool
havePassword(self)
    LoginInfo *self
CODE:
    RETVAL = self->havePassword();
OUTPUT:
    RETVAL

bool
haveHint(self)
    LoginInfo *self
CODE:
    RETVAL = self->haveHint();
OUTPUT:
    RETVAL

# --------------------------- NewSessionId ----------------------
MODULE = blackbox2        PACKAGE = blackbox2::NewSessionId
PROTOTYPES: ENABLE

NewSessionId*
new(CLASS, response)
    char *CLASS
    SessionResp *response
CODE:
    try {
        RETVAL = new NewSessionId(response);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

NewSessionId*
new_M(CLASS, response)
    char *CLASS
    MultiSessionResp *response
CODE:
    try {
        RETVAL = new NewSessionId(response);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    NewSessionId *self
CODE:
    delete self;

SV*
value(self)
    NewSessionId *self
CODE:
    RETVAL = newSVpvn(self->value().c_str(), self->value().size());
OUTPUT:
    RETVAL

SV*
domain(self)
    NewSessionId *self
CODE:
    RETVAL = newSVpvn(self->domain().c_str(), self->domain().size());
OUTPUT:
    RETVAL

SV*
expires(self)
    NewSessionId *self
CODE:
    RETVAL = newSVpvn(self->expires().c_str(), self->expires().size());
OUTPUT:
    RETVAL

bool
httpOnly(self)
    NewSessionId *self
CODE:
    RETVAL = self->httpOnly();
OUTPUT:
    RETVAL

# --------------------------- AuthInfo --------------------------
MODULE = blackbox2        PACKAGE = blackbox2::AuthInfo
PROTOTYPES: ENABLE

AuthInfo*
new(CLASS, response)
    char *CLASS
    SessionResp *response
CODE:
    try {
        RETVAL = new AuthInfo(response);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    AuthInfo *self
CODE:
    delete self;

bool
social(self)
    AuthInfo *self
CODE:
    RETVAL = self->social();
OUTPUT:
    RETVAL

SV*
age(self)
    AuthInfo *self
CODE:
    RETVAL = newSVpvn(self->age().c_str(), self->age().size());
OUTPUT:
    RETVAL

SV*
profileId(self)
    AuthInfo *self
CODE:
    RETVAL = newSVpvn(self->profileId().c_str(), self->profileId().size());
OUTPUT:
    RETVAL

bool
secure(self)
    AuthInfo *self
CODE:
    RETVAL = self->secure();
OUTPUT:
    RETVAL

# --------------------------- AllowMoreUsers --------------------
MODULE = blackbox2        PACKAGE = blackbox2::AllowMoreUsers
PROTOTYPES: ENABLE

AllowMoreUsers*
new(CLASS, response)
    char *CLASS
    MultiSessionResp *response
CODE:
    try {
        RETVAL = new AllowMoreUsers(response);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    AllowMoreUsers *self
CODE:
    delete self;

bool
allowMoreUsers(self)
    AllowMoreUsers *self
CODE:
    RETVAL = self->allowMoreUsers();
OUTPUT:
    RETVAL

# --------------------------- EmailList item ------------------
MODULE = blackbox2        PACKAGE = blackbox2::EmailList::Item
PROTOTYPES: ENABLE

EmailList__Item*
new(CLASS)
    char *CLASS
CODE:
    try {
        RETVAL = new EmailList::Item();
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    EmailList__Item *self
CODE:
    delete self;

bool
native(self)
    EmailList__Item *self
CODE:
    RETVAL = self->native();
OUTPUT:
    RETVAL

bool
validated(self)
    EmailList__Item *self
CODE:
    RETVAL = self->validated();
OUTPUT:
    RETVAL

bool
default(self)
    EmailList__Item *self
CODE:
    RETVAL = self->isDefault();
OUTPUT:
    RETVAL

bool
rpop(self)
    EmailList__Item *self
CODE:
    RETVAL = self->rpop();
OUTPUT:
    RETVAL

SV*
address(self)
    EmailList__Item *self
CODE:
    RETVAL = newSVpvn(self->address().c_str(), self->address().size());
OUTPUT:
    RETVAL

SV*
date(self)
    EmailList__Item *self
CODE:
    RETVAL = newSVpvn(self->date().c_str(), self->date().size());
OUTPUT:
    RETVAL

# --------------------------- EmailList -----------------------
MODULE = blackbox2        PACKAGE = blackbox2::EmailList
PROTOTYPES: ENABLE

EmailList*
new(CLASS, response)
    char *CLASS
    Response *response
CODE:
    try {
        RETVAL = new EmailList(response);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    EmailList *self
CODE:
    delete self;

SV*
getDefault(self)
    EmailList *self
CODE:
    RETVAL = newSVpvn(self->getDefault().c_str(), self->getDefault().size());
OUTPUT:
    RETVAL

EmailList__Item*
getDefaultItem(self)
    EmailList *self
CODE:
    const char* CLASS = "blackbox2::EmailList::Item";
    RETVAL = new EmailList__Item( *self->getDefaultItem() );
OUTPUT:
    RETVAL

bool
empty(self)
    EmailList *self
CODE:
    RETVAL = self->empty();
OUTPUT:
    RETVAL

int
size(self)
    EmailList *self
CODE:
    RETVAL = self->size();
OUTPUT:
    RETVAL

AV*
getEmailItems(self)
    EmailList *self
CODE:
    AV* ret = newAV();

    for ( EmailList::ListType::const_iterator it = self->getEmailItems().begin();
      it != self->getEmailItems().end(); ++it ) {
          SV *sv = newSVsv( &PL_sv_undef );
          EmailList::Item * pI = new EmailList::Item( *it );
          sv_setref_iv(sv, "blackbox2::EmailList::Item", (IV) pI);

          av_push(ret, sv );
    }

    RETVAL = ret;
    sv_2mortal((SV*)RETVAL);
OUTPUT:
    RETVAL

# --------------------------- AliasList item ------------------
MODULE = blackbox2        PACKAGE = blackbox2::AliasList::Item
PROTOTYPES: ENABLE

AliasList__Item*
new(CLASS)
    char *CLASS
CODE:
    try {
        RETVAL = new AliasList::Item();
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    AliasList__Item *self
CODE:
    delete self;

AliasList::Item::Type
type(self)
    AliasList__Item *self
CODE:
    RETVAL = self->type();
OUTPUT:
    RETVAL

SV*
alias(self)
    AliasList__Item *self
CODE:
    RETVAL = newSVpvn(self->alias().c_str(), self->alias().size());
OUTPUT:
    RETVAL

# --------------------------- AliasList -----------------------
MODULE = blackbox2        PACKAGE = blackbox2::AliasList
PROTOTYPES: ENABLE

AliasList*
new(CLASS, response)
    char *CLASS
    Response *response
CODE:
    try {
        RETVAL = new AliasList(response);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    AliasList *self
CODE:
    delete self;

bool
empty(self)
    AliasList *self
CODE:
    RETVAL = self->empty();
OUTPUT:
    RETVAL

int
size(self)
    AliasList *self
CODE:
    RETVAL = self->size();
OUTPUT:
    RETVAL

AV*
getAliases(self)
    AliasList *self
CODE:
    AV* ret = newAV();

    for ( AliasList::ListType::const_iterator it = self->getAliases().begin();
      it != self->getAliases().end(); ++it ) {
          SV *sv = newSVsv( &PL_sv_undef );
          AliasList::Item * pI = new AliasList::Item( *it );
          sv_setref_iv(sv, "blackbox2::AliasList::Item", (IV) pI);

          av_push(ret, sv );
    }

    RETVAL = ret;
    sv_2mortal((SV*)RETVAL);
OUTPUT:
    RETVAL

# --------------------------- MailHostsList item --------------
MODULE = blackbox2        PACKAGE = blackbox2::MailHostsList::Item
PROTOTYPES: ENABLE

MailHostsList__Item*
new(CLASS)
    char *CLASS
CODE:
    try {
        RETVAL = new MailHostsList::Item();
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    MailHostsList__Item *self
CODE:
    delete self;

SV*
hostId(self)
    MailHostsList__Item *self
CODE:
    RETVAL = newSVpvn(self->hostId().c_str(), self->hostId().size());
OUTPUT:
    RETVAL

SV*
hostIp(self)
    MailHostsList__Item *self
CODE:
    RETVAL = newSVpvn(self->hostIp().c_str(), self->hostIp().size());
OUTPUT:
    RETVAL

SV*
hostName(self)
    MailHostsList__Item *self
CODE:
    RETVAL = newSVpvn(self->hostName().c_str(), self->hostName().size());
OUTPUT:
    RETVAL

SV*
dbId(self)
    MailHostsList__Item *self
CODE:
    RETVAL = newSVpvn(self->dbId().c_str(), self->dbId().size());
OUTPUT:
    RETVAL

SV*
sid(self)
    MailHostsList__Item *self
CODE:
    RETVAL = newSVpvn(self->sid().c_str(), self->sid().size());
OUTPUT:
    RETVAL

SV*
priority(self)
    MailHostsList__Item *self
CODE:
    RETVAL = newSVpvn(self->priority().c_str(), self->priority().size());
OUTPUT:
    RETVAL

SV*
mx(self)
    MailHostsList__Item *self
CODE:
    RETVAL = newSVpvn(self->mx().c_str(), self->mx().size());
OUTPUT:
    RETVAL

# --------------------------- MailHostList --------------------
MODULE = blackbox2        PACKAGE = blackbox2::MailHostsList
PROTOTYPES: ENABLE

MailHostsList*
new(CLASS, response)
    char *CLASS
    HostResp *response
CODE:
    try {
        RETVAL = new MailHostsList(response);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    MailHostsList *self
CODE:
    delete self;

bool
empty(self)
    MailHostsList *self
CODE:
    RETVAL = self->empty();
OUTPUT:
    RETVAL

int
size(self)
    MailHostsList *self
CODE:
    RETVAL = self->size();
OUTPUT:
    RETVAL

AV*
getHosts(self)
    MailHostsList *self
CODE:
    AV* ret = newAV();

    for ( MailHostsList::ListType::const_iterator it = self->getHosts().begin();
      it != self->getHosts().end(); ++it ) {
          SV *sv = newSVsv( &PL_sv_undef );
          MailHostsList::Item * pI = new MailHostsList::Item( *it );
          sv_setref_iv(sv, "blackbox2::MailHostsList::Item", (IV) pI);

          av_push(ret, sv );
    }

    RETVAL = ret;
    sv_2mortal((SV*)RETVAL);
OUTPUT:
    RETVAL

# --------------------------- OAuthInfo -----------------------
MODULE = blackbox2        PACKAGE = blackbox2::OAuthInfo
PROTOTYPES: ENABLE

OAuthInfo*
new(CLASS, response)
    char *CLASS
    SessionResp *response
CODE:
    try {
        RETVAL = new OAuthInfo(response);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    OAuthInfo *self
CODE:
    delete self;

bool
empty(self)
    OAuthInfo *self
CODE:
    RETVAL = self->empty();
OUTPUT:
    RETVAL

int
size(self)
    OAuthInfo *self
CODE:
    RETVAL = self->size();
OUTPUT:
    RETVAL

HV*
getInfo(self)
    OAuthInfo *self
CODE:
    HV* ret_values = newHV();

    for ( OAuthInfo::MapType::const_iterator it = self->getInfo().begin();
      it != self->getInfo().end(); ++it ) {

      hv_store(ret_values, it->first.c_str(), it->first.size(),
               newSVpv(it->second.c_str(), it->second.size()), 0);
    }

    RETVAL = ret_values;
    sv_2mortal((SV*)RETVAL);
OUTPUT:
    RETVAL

# --------------------------- BruteforcePolicy ------------------
MODULE = blackbox2        PACKAGE = blackbox2::BruteforcePolicy
PROTOTYPES: ENABLE

BruteforcePolicy*
new(CLASS, response)
    char *CLASS
    LoginResp *response
CODE:
    try {
        RETVAL = new BruteforcePolicy(response);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    BruteforcePolicy *self
CODE:
    delete self;

BruteforcePolicy::Mode
type(self)
    BruteforcePolicy *self
CODE:
    RETVAL = self->mode();
OUTPUT:
    RETVAL

int
delay(self)
    BruteforcePolicy *self
CODE:
    RETVAL = self->delay();
OUTPUT:
    RETVAL

# --------------------------- SessionKind -----------------------
MODULE = blackbox2        PACKAGE = blackbox2::SessionKind
PROTOTYPES: ENABLE

SessionKind*
new(CLASS, response)
    char *CLASS
    SessionResp *response
CODE:
    try {
        RETVAL = new SessionKind(response);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

SessionKind*
new_M(CLASS, response)
    char *CLASS
    MultiSessionResp *response
CODE:
    try {
        RETVAL = new SessionKind(response);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    SessionKind *self
CODE:
    delete self;

SessionKind::Kind
kind(self)
    SessionKind *self
CODE:
    RETVAL = self->kind();
OUTPUT:
    RETVAL

SV*
kindName(self)
    SessionKind *self
CODE:
    RETVAL = newSVpvn(self->kindName().c_str(), self->kindName().size());
OUTPUT:
    RETVAL

# --------------------------- AuthId ----------------------------
MODULE = blackbox2        PACKAGE = blackbox2::AuthId
PROTOTYPES: ENABLE

AuthId*
new(CLASS, response)
    char *CLASS
    SessionResp *response
CODE:
    try {
        RETVAL = new AuthId(response);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

AuthId*
new_M(CLASS, response)
    char *CLASS
    MultiSessionResp *response
CODE:
    try {
        RETVAL = new AuthId(response);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    AuthId *self
CODE:
    delete self;

SV*
time(self)
    AuthId *self
CODE:
    RETVAL = newSVpvn(self->time().c_str(), self->time().size());
OUTPUT:
    RETVAL

SV*
userIp(self)
    AuthId *self
CODE:
    RETVAL = newSVpvn(self->userIp().c_str(), self->userIp().size());
OUTPUT:
    RETVAL

SV*
hostId(self)
    AuthId *self
CODE:
    RETVAL = newSVpvn(self->hostId().c_str(), self->hostId().size());
OUTPUT:
    RETVAL

SV*
authId(self)
    AuthId *self
CODE:
    RETVAL = newSVpvn(self->authId().c_str(), self->authId().size());
OUTPUT:
    RETVAL

# --------------------------- PasswordQuality -------------------
MODULE = blackbox2        PACKAGE = blackbox2::PasswordQuality
PROTOTYPES: ENABLE

PasswordQuality*
new_L(CLASS, response)
    char *CLASS
    LoginResp *response
CODE:
    try {
        RETVAL = new PasswordQuality(response);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

PasswordQuality*
new(CLASS, response)
    char *CLASS
    PwdQualityResp *response
CODE:
    try {
        RETVAL = new PasswordQuality(response);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    PasswordQuality *self
CODE:
    delete self;

SV*
quality(self)
    PasswordQuality *self
CODE:
    RETVAL = newSVpvn(self->quality().c_str(), self->quality().size());
OUTPUT:
    RETVAL

# --------------------------- ConnectionId ----------------------
MODULE = blackbox2        PACKAGE = blackbox2::ConnectionId
PROTOTYPES: ENABLE

ConnectionId*
new(CLASS, response)
    char *CLASS
    SessionResp *response
CODE:
    try {
        RETVAL = new ConnectionId(response);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

ConnectionId*
new_M(CLASS, response)
    char *CLASS
    MultiSessionResp *response
CODE:
    try {
        RETVAL = new ConnectionId(response);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

ConnectionId*
new_L(CLASS, response)
    char *CLASS
    LoginResp *response
CODE:
    try {
        RETVAL = new ConnectionId(response);
    }
    catch (const std::exception &e) {
        croak("%s", e.what());
    }
OUTPUT:
    RETVAL

void
DESTROY(self)
    ConnectionId *self
CODE:
    delete self;

SV*
connectionId(self)
    ConnectionId *self
CODE:
    RETVAL = newSVpvn(self->connectionId().c_str(), self->connectionId().size());
OUTPUT:
    RETVAL

