# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl yandex-user-settings.t'

#########################

# change 'tests => 1' to 'tests => last_test_to_print';
#use Data::Dumper;
use Test::More tests => 209;
BEGIN {
    use_ok('blackbox2')
};

#use Data::Dumper;

#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.


sub no_exception {
    my $opts = blackbox2::Options->new();
    $opts->add("a", "b");
    return undef
}

is(no_exception(), undef, "exception test");

sub options {
    my $opts = blackbox2::Options->new();

    $opts->add("custom_opt","yes	%");

    $opts->add_opt( blackbox2::Option->Regname() );
    $opts->add_opt( blackbox2::Option->GetYandexEmails() );
    $opts->add_opt( blackbox2::Option->GetSocialAliases() );

    my $testmail = blackbox2::OptTestEmail->new("ya\@ya.ru");
    $testmail->format($opts);

    return blackbox2::InfoRequest_Uid("12345", "127.0.0.1", $opts);
}

is(options(), "method=userinfo&uid=12345&userip=127%2E0%2E0%2E1&custom_opt=yes%09%25&regname=yes&emails=getyandex&aliases=getsocial&emails=testone&addrtotest=ya%40ya%2Eru" , "request options test");

sub dbfields {
    my $fields = blackbox2::DBFields->new();

    $fields->add("as df");
    $fields->add("qwert");

    return blackbox2::InfoRequest_Uid("12345", "127.0.0.1", $fields->getOptions() );
}

is(dbfields(), "method=userinfo&uid=12345&userip=127%2E0%2E0%2E1&dbfields=as%20df,qwert" , "dbfields option test");

sub attributes {
    my $attrs = blackbox2::Attributes->new();

    $attrs->add("5");
    $attrs->add("111");
    $attrs->add("5");
    $attrs->add("1");

    return blackbox2::InfoRequest_Uid("12345", "127.0.0.1", $attrs->getOptions() );
}

is(attributes(), "method=userinfo&uid=12345&userip=127%2E0%2E0%2E1&attributes=1,111,5" , "attributes option test");

sub info_request_ssid {
    my $ssid = blackbox2::SuidSid->new("4321","16");

    return blackbox2::InfoRequest_SSid($ssid, "127.0.0.1", blackbox2::Options->new() );
}

is( info_request_ssid(), "method=userinfo&suid=4321&sid=16&userip=127%2E0%2E0%2E1", "InfoRequest by (suid,sid) test");

sub info_request_lsid {
    my $ssid = blackbox2::LoginSid->new("super.user","16");
    my $aliases = blackbox2::OptAliases->new();

    $aliases->add("5");
    $aliases->add("13");

    return blackbox2::InfoRequest_LSid($ssid, "127.0.0.1", $aliases->getOptions() );
}

is( info_request_lsid(), "method=userinfo&login=super%2Euser&sid=16&userip=127%2E0%2E0%2E1&aliases=13,5", "InfoRequest by (login,sid) test");

sub info_request_bulk {
    my $uids = ["123","12345","111"];
    my $opts = blackbox2::Options->new();

    $opts->add_opt( blackbox2::Option->GetAllAliases() );
    $opts->add_attributes( blackbox2::Attributes->new() );

    return blackbox2::InfoRequest_Bulk($uids, "8.8.8.8", $opts );
}

is( info_request_bulk(), "method=userinfo&uid=123,12345,111&userip=8%2E8%2E8%2E8&aliases=all", "Bulk InfoRequest test");

sub login_request {
    my $opts = blackbox2::Options->new();

    $opts->add_opt( blackbox2::Option->Version2() );
    $opts->add_opt( blackbox2::Option->FullInfo() );
    return blackbox2::LoginRequest(blackbox2::LoginSid->new("vasya","2"), "pa\$\$w0rd", "mail", "127.0.0.1", $opts );
}

my $log_data = login_request();

is( $log_data->{uri}, "method=login&login=vasya&sid=2&authtype=mail&userip=127%2E0%2E0%2E1&ver=2&full_info=yes", "LoginRequest uri test");
is( $log_data->{postData}, "password=pa%24%24w0rd", "LoginRequest body test");

sub login_request_uid {
    my $opts = blackbox2::Options->new();

    $opts->add_opt( blackbox2::Option->Version2() );
    return blackbox2::LoginRequest_Uid("31415926", "pa+\%w0rd", "mail", "127.0.0.1", $opts );
}

my $log_data_uid = login_request_uid();

is( $log_data_uid->{uri}, "method=login&uid=31415926&authtype=mail&userip=127%2E0%2E0%2E1&ver=2", "LoginRequestUid uri test");
is( $log_data_uid->{postData}, "password=pa%2B%25w0rd", "LoginRequestUid body test");

sub session_request {
    my $opts = blackbox2::Options->new();

    $opts->add_opt( blackbox2::Option->AuthId() );
    $opts->add_opt( blackbox2::Option->Multisession() );
    return blackbox2::SessionIDRequest("1234.1234.1234.1234", "yandex.ru", "127.0.0.1", $opts);
}

is( session_request(), "method=sessionid&sessionid=1234%2E1234%2E1234%2E1234&host=yandex%2Eru&userip=127%2E0%2E0%2E1&authid=yes&multisession=yes", "SessionRequest test");

sub oauth_request {
    return blackbox2::OAuthRequest("24dc10049bec4f353452809ec2b82282", "127.0.0.1", blackbox2::Options->new());
}

is( oauth_request(), "method=oauth&oauth_token=24dc10049bec4f353452809ec2b82282&userip=127%2E0%2E0%2E1", "SessionRequest test");

sub mailhost_create_request {
    return blackbox2::MailHostCreateRequest("yandex","mdb666","-60", "mxc33.yandex.ru");
}

is( mailhost_create_request(), "method=mailhost&op=create&scope=yandex&db_id=mdb666&prio=-60&mx=mxc33%2Eyandex%2Eru");

sub mailhost_delete_request {
    return blackbox2::MailHostDeleteRequest("pdd", "pdd_db");
}

is( mailhost_delete_request(), "method=mailhost&op=delete&scope=pdd&db_id=pdd_db");

sub mailhost_assign_request {
    return blackbox2::MailHostAssignRequest("yandex","123456","mdb_666");
}

is( mailhost_assign_request(), "method=mailhost&op=assign&scope=yandex&suid=123456&db_id=mdb_666");

sub mailhost_setprio_request {
    return blackbox2::MailHostSetPriorityRequest("yandex","cool_db","-5");
}

is( mailhost_setprio_request(), "method=mailhost&op=setprio&scope=yandex&db_id=cool_db&prio=-5");

sub mailhost_find_request {
    return blackbox2::MailHostFindRequest("invalid_scope","0");
}

is( mailhost_find_request(), "method=mailhost&op=find&scope=invalid_scope&prio=0");

sub pwd_quality_request {
    return blackbox2::PwdQualityRequest("1320236171.-14980.0.99538348.2:276863426:240.8:1320236171785:1600958165:60.668:300531493.79537.17370.ba4560331173a20ee52ffeb4cb084076", "yandex.ru");
}

is( pwd_quality_request(), "method=pwdquality&sessionid=1320236171%2E-14980%2E0%2E99538348%2E2%3A276863426%3A240%2E8%3A1320236171785%3A1600958165%3A60%2E668%3A300531493%2E79537%2E17370%2Eba4560331173a20ee52ffeb4cb084076&host=yandex%2Eru", "Password Quality Request test");

my $req_body = "<?xml version=\"1.0\" encoding=\"utf-8\"?>
    <doc>
    <status id=\"0\">VALID</status>
    <error>OK</error>
    <uid hosted=\"0\" domid=\"\" domain=\"\">20903734</uid>
    <karma confirmed=\"0\">75</karma>
    <aliases>
      <alias type=\"7\">pdd-login</alias>
      <alias type=\"5\">вася\@пупкин.рф</alias>
      <alias type=\"15\">123456789</alias>
      <alias type=\"6\">uid-5djew2ti</alias>
    </aliases>
    <login>vasya-666</login>
    <have_password>0</have_password>
    <have_hint>1</have_hint>
    <display_name>
        <name>Бруно &lt;Бабалеус&gt;</name>
        <social>
            <profile_id>155</profile_id>
            <provider>fb</provider>
            <redirect_target>1302533044.93231.42.5cace44d6662c11d84362403ef7f8873</redirect_target>
        </social>
        <avatar>
          <default>12345</default>
        </avatar>
    </display_name>
    </doc>";

my $resp = blackbox2::Response->new($req_body);

is( $resp->message(),"OK", "Response message test");
is( blackbox2::Uid->new($resp)->uid(),"20903734", "Uid test");
is( blackbox2::Uid->new($resp)->hosted(),"","Hosted test");
is( blackbox2::KarmaInfo->new($resp)->karma(),"75","Karma test");
is( blackbox2::KarmaInfo->new($resp)->karmaStatus(),"","Karma status test");

my $dname = blackbox2::DisplayNameInfo->new($resp);

is( $dname->name(), "Бруно <Бабалеус>", "DisplayNameInfo name test");
is( $dname->social(), "1", "DisplayNameInfo social test");
is( $dname->socProfile(), "155", "DisplayNameInfo profile test");
is( $dname->socProvider(), "fb", "DisplayNameInfo provider test");
is( $dname->socTarget(), "1302533044.93231.42.5cace44d6662c11d84362403ef7f8873", "DisplayNameInfo redirect target test");
is( $dname->defaultAvatar(), "12345", "DisplayNameInfo default avatar test");

my $log = blackbox2::LoginInfo->new($resp);

is( $log->login(), "vasya-666", "LoginInfo login test");
is( $log->havePassword(), "", "LoginInfo havePassword test");
is( $log->haveHint(), "1", "LoginInfo haveHint test");

my $alist = blackbox2::AliasList->new($resp);

is( $alist->size(), "5", "Alias list size test");

is( $alist->getAliases()->[0]->type(), blackbox2::AliasPDD,"Alias list item type test");
is( $alist->getAliases()->[0]->alias(),"pdd-login","Alias list item alias test");
is( $alist->getAliases()->[2]->type(), blackbox2::AliasLite,"Alias list item type test");
is( $alist->getAliases()->[2]->alias(),"вася\@пупкин.рф","Alias list item alias test");
is( $alist->getAliases()->[3]->type(), blackbox2::AliasKinopoiskId,"Alias list item type test");
is( $alist->getAliases()->[3]->alias(),"123456789","Alias list item alias test");
is( $alist->getAliases()->[4]->type(), blackbox2::AliasSocial,"Alias list item type test");
is( $alist->getAliases()->[4]->alias(),"uid-5djew2ti","Alias list item alias test");

my $sess_body = "<?xml version=\"1.0\" encoding=\"utf-8\"?>
    <doc>
    <status id=\"0\">VALID</status>
    <age>4177</age>
    <ttl>5</ttl>
    <error>some message</error>
    <uid hosted=\"1\" domid=\"51\" domain=\"xn--d1abbgf6aiiy.xn--p1ai\" mx=\"1\" domain_ena=\"1\" catch_all=\"0\">11806301</uid>
    <karma confirmed=\"0\">0</karma>
    <karma_status></karma_status>
    <regname>junit-test</regname>
    <dbfield id=\"account_info.fio.uid\">\@В &lt;html&gt; &amp;Вася</dbfield>
    <dbfield id=\"subscription.login.2\">name\@xn--d1acpjx3f.xn--p1ai</dbfield>
    <dbfield id=\"account_info.country.uid\">xn--d1acpjx3f</dbfield>
    <attributes>
        <attribute type=\"134\"></attribute>
        <attribute type=\"135\">1414141414</attribute>
    </attributes>
    <address-list>
      <address validated=\"1\" default=\"0\" rpop=\"0\" native=\"1\" born-date=\"2010-10-04 00:00:00\">junit-test\@YA.ru</address>
      <address validated=\"1\" default=\"0\" rpop=\"0\" native=\"1\" born-date=\"2010-10-04 00:00:00\">junit-test\@narod.ru</address>
      <address validated=\"1\" default=\"1\" rpop=\"0\" native=\"1\" born-date=\"2010-10-04 00:00:00\">junit-test\@yandex.by</address>
      <address validated=\"0\" default=\"0\" rpop=\"0\" native=\"0\" born-date=\"2010-11-08 14:14:05\">$%\{\}\@yandex.ru</address>
    </address-list>
    <auth>
        <social>
            <profile_id>1122334455</profile_id>
        </social>
        <password_verification_age>-1</password_verification_age>
        <secure>1</secure>
    </auth>
    <OAuth>
        <some_key>some_value</some_key>
        <another_key>another value</another_key>
    </OAuth>
    <special id=\"1\">SUPPORT</special>
    <authid time=\"1317893502628\" ip=\"95.108.173.65\" host=\"127\">1317893502628:1600957761:127</authid>
    <new-session domain=\".yandex.com.tr\" expires=\"0\" http-only=\"0\">1333975797.135.2.11806301.2:565024:5.yandex_com_tr:10320.1393.a99d9ec4695d1cbc328633c44493fcea</new-session>
    <connection_id>s:1317893502628:1600957761:127</connection_id>
    </doc>";

my $sresp = blackbox2::SessionResp->new($sess_body);

is( $sresp->message(),"some message", "Session Response message test");
is( $sresp->status(), blackbox2::SessionValid, "Session Response status test");
is( $sresp->age(),"4177", "Session Response age test");
is( $sresp->isLite(),"", "Session Response lite test");
is( blackbox2::Regname->new($sresp)->value(),"junit-test", "Regname test");
is( blackbox2::Uid->new($sresp)->uid(),"11806301","Session Uid test");
is( blackbox2::Uid->new($sresp)->hosted(),"1","Session Hosted test");

my $pdd = blackbox2::PDDUserInfo->new($sresp);

is( $pdd->domId(), "51", "PDD domain Id test");
is( $pdd->domain(), "президент.рф", "PDD domain test");
is( $pdd->mx(), "1", "PDD mx test");
is( $pdd->domEna(), "1", "PDD domain_ena test");
is( $pdd->catchAll(), "0", "PDD catch_all test");

is( blackbox2::KarmaInfo->new($sresp)->karma(),"0","Session karma test");
is( blackbox2::KarmaInfo->new($sresp)->karmaStatus(),"","Session karma status test");

my $auth = blackbox2::AuthInfo->new($sresp);

is( $auth->social(), "1", "AuthInfo social test");
is( $auth->age(), "-1", "AuthInfo age test");
is( $auth->profileId(), "1122334455", "AuthInfo profileId test");
is( $auth->secure(), "1", "AuthInfo secure test");

my $oauth = blackbox2::OAuthInfo->new($sresp);

is( $oauth->size(), "2", "OAuth info size test");
is( $oauth->getInfo()->{some_key}, "some_value", "OAuth info attribute test");
is( $oauth->getInfo()->{another_key}, "another value", "OAuth info attribute test");

my $skind = blackbox2::SessionKind->new($sresp);

is( $skind->kind(), blackbox2::SessionKindSupport, "SessionKind kind value test");
is( $skind->kindName(), "SUPPORT", "SessionKind kind name test");

my $newid = blackbox2::NewSessionId->new($sresp);

is( $newid->value(), "1333975797.135.2.11806301.2:565024:5.yandex_com_tr:10320.1393.a99d9ec4695d1cbc328633c44493fcea", "Sessionid value test");
is( $newid->domain(), ".yandex.com.tr", "Sessionid domain test");
is( $newid->expires(), "0", "Sessionid expires test");
is( $newid->httpOnly(), "", "Sessionid httpOnly test");

my $authid = blackbox2::AuthId->new($sresp);

is( $authid->time(), "1317893502628" , "AuthId time test");
is( $authid->userIp(), "95.108.173.65" , "AuthId user ip test");
is( $authid->hostId(), "127" , "AuthId host id test");
is( $authid->authId(), "1317893502628:1600957761:127" , "AuthId auth id test");

my $conn_id = blackbox2::ConnectionId->new($sresp);

is ($conn_id->connectionId(), "s:1317893502628:1600957761:127", "Session ConnectionId test");

my $mlist = blackbox2::EmailList->new($sresp);

is( $mlist->size(), "4", "Email list size test");

is( $mlist->getDefault(), "junit-test\@yandex.by", "Default email addr test");
is( $mlist->getDefaultItem()->native(), "1", "Default email native test");
is( $mlist->getDefaultItem()->rpop(), "", "Default email rpop test");

is( $mlist->getEmailItems()->[1]->address(), "junit-test\@narod.ru", "Email list item address test");
is( $mlist->getEmailItems()->[1]->native(), "1", "Email list item native test");
is( $mlist->getEmailItems()->[1]->date(), "2010-10-04 00:00:00", "Email list item date test");
is( $mlist->getEmailItems()->[3]->address(), "0\{\}\@yandex.ru", "Email list item address test");
is( $mlist->getEmailItems()->[3]->native(), "", "Email list item native test");
is( $mlist->getEmailItems()->[3]->date(), "2010-11-08 14:14:05", "Email list item date test");

my $flds = blackbox2::DBFields->new();
$flds->readResponse($sresp);

is ( $flds->size(), "3", "DBFields response size test");
is ( $flds->get("asdf"), "", "DBFields response bad field test");
is ( $flds->get("subscription.login.2"), "name\@яндекс.рф", "DBFields response login test");
is ( $flds->get("account_info.fio.uid"), "\@В <html> &Вася", "DBFields response fio test");
is ( $flds->get("account_info.country.uid"), "xn--d1acpjx3f", "DBFields response country test");

my $attrs = blackbox2::Attributes->new();
$attrs->readResponse($sresp);

is ( $attrs->size(), "2", "Attributes response size test");
is ( $attrs->get("100"), "", "Attributes response bad field test");
is ( $attrs->get("134"), "", "Attributes response empty attr test");
is ( $attrs->get("135"), "1414141414", "Attributes response test");

my $msess_body= "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
    <doc>
    <status id=\"0\">VALID</status>
    <error>OK</error>
    <age>4266</age>
    <ttl>5</ttl>
    <default_uid>70502</default_uid>
    <user id=\"70502\">
        <status id=\"0\">VALID</status>
        <uid hosted=\"0\">70502</uid>
        <login>bbtst_staff</login>
        <have_password>1</have_password>
        <have_hint>1</have_hint>
        <karma confirmed=\"0\">0</karma>
        <karma_status>0</karma_status>
        <auth>
            <password_verification_age>-1</password_verification_age>
            <secure>0</secure>
        </auth>
    </user>
    <user id=\"3000329133\">
        <status id=\"4\">DISABLED</status>
        <uid hosted=\"0\">3000329133</uid>
        <login>test-adresa-6</login>
        <have_password>1</have_password>
        <have_hint>0</have_hint>
        <karma confirmed=\"0\">0</karma>
        <karma_status>6000</karma_status>
        <auth>
            <password_verification_age>2593061</password_verification_age>
            <secure>1</secure>
        </auth>
    </user>
    <connection_id>s:1401106407589:h5RsXw:af</connection_id>
    <authid time=\"1401106407589\" ip=\"95.108.148.135\" host=\"af\">1401106407589:h5RsXw:af</authid>
    <special id=\"2\">STRESS</special>
    <allow_more_users>1</allow_more_users>
    </doc>";

my $msresp = blackbox2::MultiSessionResp->new($msess_body);

is( $msresp->message(),"OK", "MultiSession Response message test");
is( $msresp->status(), blackbox2::SessionValid, "MultiSession Response status test");
is( $msresp->age(),"4266", "MultiSession Response age test");
is( $msresp->defaultUid(),"70502", "MultiSession Response default uid test");
is( $msresp->count(),"2", "MultiSession Response user count test");

is( blackbox2::SessionKind->new_M($msresp)->kind(), blackbox2::SessionKindStress, "MultiSession session kind test");

my $mauthid = blackbox2::AuthId->new_M($msresp);

is( $mauthid->time(), "1401106407589" , "AuthId time test");
is( $mauthid->userIp(), "95.108.148.135" , "AuthId user ip test");
is( $mauthid->hostId(), "af" , "AuthId host id test");
is( $mauthid->authId(), "1401106407589:h5RsXw:af" , "AuthId auth id test");

my $mconn_id = blackbox2::ConnectionId->new_M($msresp);

is ($mconn_id->connectionId(), "s:1401106407589:h5RsXw:af", "MultiSession ConnectionId test");

is( $msresp->id(0),"70502", "MultiSession Response user id test");
is( $msresp->id(1),"3000329133", "MultiSession Response user id test");

my $sr1 = $msresp->user(0);
my $sr2 = $msresp->user(1);

is( blackbox2::Uid->new($sr1)->uid(),"70502","MultiSession Uid test");
is( blackbox2::Uid->new($sr1)->hosted(),"","MultiSession Hosted test");
is( blackbox2::Uid->new($sr2)->uid(),"3000329133","MultiSession Uid test");
is( blackbox2::Uid->new($sr2)->hosted(),"","MultiSession Hosted test");

is( $sr1->message(),"", "MultiSession Response message test");
is( $sr1->status(), blackbox2::SessionValid, "MultiSession Response status test");
is( $sr1->age(),"", "MultiSession Response age test");

is( $sr2->message(),"", "MultiSession Response message test");
is( $sr2->status(), blackbox2::SessionDisabled, "MultiSession Response status test");
is( $sr2->age(),"", "MultiSession Response age test");

is( blackbox2::KarmaInfo->new($sr1)->karma(),"0","MultiSession karma test");
is( blackbox2::KarmaInfo->new($sr1)->karmaStatus(),"0","MultiSession karma status test");

my $mauth1 = blackbox2::AuthInfo->new($sr1);

is( $mauth1->social(), "", "AuthInfo social test");
is( $mauth1->age(), "-1", "AuthInfo age test");
is( $mauth1->profileId(), "", "AuthInfo profileId test");
is( $mauth1->secure(), "", "AuthInfo secure test");

my $mlog1 = blackbox2::LoginInfo->new($sr1);

is( $mlog1->login(), "bbtst_staff", "LoginInfo login test");
is( $mlog1->havePassword(), "1", "LoginInfo havePassword test");
is( $mlog1->haveHint(), "1", "LoginInfo haveHint test");

is( blackbox2::KarmaInfo->new($sr2)->karma(),"0","MultiSession karma test");
is( blackbox2::KarmaInfo->new($sr2)->karmaStatus(),"6000","MultiSession karma status test");

my $mauth2 = blackbox2::AuthInfo->new($sr2);

is( $mauth2->social(), "", "AuthInfo social test");
is( $mauth2->age(), "2593061", "AuthInfo age test");
is( $mauth2->profileId(), "", "AuthInfo profileId test");
is( $mauth2->secure(), "1", "AuthInfo secure test");

my $more_users = blackbox2::AllowMoreUsers->new($msresp);

is( $more_users->allowMoreUsers(), "1", "AllowMoreUsers test");

my $mlog2 = blackbox2::LoginInfo->new($sr2);

is( $mlog2->login(), "test-adresa-6", "LoginInfo login test");
is( $mlog2->havePassword(), "1", "LoginInfo havePassword test");
is( $mlog2->haveHint(), "", "LoginInfo haveHint test");

my $host_body = "<?xml version=\"1.0\" encoding=\"utf-8\"?>
    <doc>
    <status id=\"0\">OK</status>
    <entry hostd_id=\"1\" host_ip=\"\" host_name=\"w1.www.narod.ru\" db_id=\"\" sid=\"2\" prio=\"-1\" mx=\"mx1.yandex.ru\"/>
    <entry hostd_id=\"25\" host_ip=\"127.0.0.1\" host_name=\"\" db_id=\"maildb41\" sid=\"4\" prio=\"\" mx=\"mxc222.yandex.ru\"/>
    <entry hostd_id=\"666\" host_ip=\"8.8.8.8\" host_name=\"\" db_id=\"mdb666\" sid=\"16\" prio=\"2500\" mx=\"\"/>
    </doc>";

my $hresp = blackbox2::HostResp->new($host_body);

is( $hresp->status(), blackbox2::HostOK, "MailHost status check");
is( $hresp->message(), "OK", "MailHost message check");

my $hlist = blackbox2::MailHostsList->new($hresp);

is( $hlist->size(), "3", "MailHost list size test");

is( $hlist->getHosts()->[0]->hostId(), "1", "MailHost list item host_id test");
is( $hlist->getHosts()->[0]->hostIp(), "", "MailHost list item host_ip test");
is( $hlist->getHosts()->[0]->hostName(), "w1.www.narod.ru", "MailHost list item host_name test");
is( $hlist->getHosts()->[0]->dbId(), "", "MailHost list item db_id test");
is( $hlist->getHosts()->[0]->sid(), "2", "MailHost list item sid test");
is( $hlist->getHosts()->[0]->priority(), "-1", "MailHost list item priority test");
is( $hlist->getHosts()->[0]->mx(), "mx1.yandex.ru", "MailHost list item mx test");
is( $hlist->getHosts()->[1]->hostId(), "25", "MailHost list item host_id test");
is( $hlist->getHosts()->[1]->hostIp(), "127.0.0.1", "MailHost list item host_ip test");
is( $hlist->getHosts()->[1]->hostName(), "", "MailHost list item host_name test");
is( $hlist->getHosts()->[1]->dbId(), "maildb41", "MailHost list item db_id test");
is( $hlist->getHosts()->[1]->sid(), "4", "MailHost list item sid test");
is( $hlist->getHosts()->[1]->priority(), "", "MailHost list item priority test");
is( $hlist->getHosts()->[1]->mx(), "mxc222.yandex.ru", "MailHost list item mx test");
is( $hlist->getHosts()->[2]->hostId(), "666", "MailHost list item host_id test");
is( $hlist->getHosts()->[2]->hostIp(), "8.8.8.8", "MailHost list item host_ip test");
is( $hlist->getHosts()->[2]->hostName(), "", "MailHost list item host_name test");
is( $hlist->getHosts()->[2]->dbId(), "mdb666", "MailHost list item db_id test");
is( $hlist->getHosts()->[2]->sid(), "16", "MailHost list item sid test");
is( $hlist->getHosts()->[2]->priority(), "2500", "MailHost list item priority test");
is( $hlist->getHosts()->[2]->mx(), "", "MailHost list item mx test");

my $bulk_body = "<?xml version=\"1.0\" encoding=\"utf-8\"?>
    <doc>
    <error>OK</error>
    <user id=\"12345\">
        <uid hosted=\"0\">12345</uid>
        <karma confirmed=\"0\">75</karma>
        <karma_status>1234</karma_status>
    </user>
    <user id=\"54321\">
        <uid hosted=\"1\" domid=\"10\" domain=\"test.ru\" mx=\"\" domain_ena=\"0\" catch_all=\"\">654321</uid>
        <karma confirmed=\"0\">25</karma>
        <karma_status>4321</karma_status>
    </user>
    </doc>";

my $bresp = blackbox2::BulkResponse->new($bulk_body);

is( $bresp->message(), "OK", "Bulk response message test");
is( $bresp->count(), "2", "Bulk response count test");

is( $bresp->id(0), "12345", "Bulk response id test");
is( $bresp->id(1), "54321", "Bulk response id test");

my $u1 = blackbox2::Uid->new( $bresp->user(0) );
my $u2 = blackbox2::Uid->new( $bresp->user(1) );
my $k1 = blackbox2::KarmaInfo->new( $bresp->user(0) );
my $k2 = blackbox2::KarmaInfo->new( $bresp->user(1) );
my $p1 = blackbox2::PDDUserInfo->new( $bresp->user(0) );
my $p2 = blackbox2::PDDUserInfo->new( $bresp->user(1) );

is( $u1->uid(), "12345", "Bulk response uid test");
is( $u2->uid(), "654321", "Bulk response uid test");
is( $u1->hosted(), "", "Bulk response hosted test");
is( $u2->hosted(), "1", "Bulk response hosted test");
is( $k1->karma(), "75", "Bulk response karma test");
is( $k2->karma(), "25", "Bulk response karma test");
is( $k1->karmaStatus(), "1234", "Bulk response karma status test");
is( $k2->karmaStatus(), "4321", "Bulk response karma status test");

is( $p1->domId(), "", "PDD domain Id test");
is( $p1->domain(), "", "PDD domain test");
is( $p1->mx(), "", "PDD mx test");
is( $p1->domEna(), "", "PDD domain_ena test");
is( $p1->catchAll(), "", "PDD catch_all test");
is( $p2->domId(), "10", "PDD domain Id test");
is( $p2->domain(), "test.ru", "PDD domain test");
is( $p2->mx(), "", "PDD mx test");
is( $p2->domEna(), "0", "PDD domain_ena test");
is( $p2->catchAll(), "", "PDD catch_all test");


my $logv2_body ="<?xml version=\"1.0\" encoding=\"UTF-8\"?>
    <doc>
    <login_status id=\"1\">VALID</login_status>
    <password_status id=\"3\">COMPROMISED</password_status>
    <bruteforce_policy>
        <delay>123</delay>
    </bruteforce_policy>
    <comment>Password expired</comment>
    <password_quality>33</password_quality>
    <uid hosted=\"0\" domid=\"\" domain=\"\" mx=\"\">11806307</uid>
    <connection_id>t:12345</connection_id>
    </doc>";

my $l2resp = blackbox2::LoginResp->new($logv2_body);

is( $l2resp->status(), blackbox2::LoginCompromised, "Login v2 response status test");
is( $l2resp->accStatus(), blackbox2::AccountValid, "Login v2 response account status test");
is( $l2resp->pwdStatus(), blackbox2::PasswdCompromised, "Login v2 response password status test");
is( $l2resp->message(), "Password expired", "Login v2 response message test");

my $bfpol = blackbox2::BruteforcePolicy->new($l2resp);

is( $bfpol->type(), blackbox2::ResistModeDelay, "Login v2 response bruteforce policy type test");
is( $bfpol->delay(), 123, "Login v2 response bruteforce policy delay test");

my $pwd_quality = blackbox2::PasswordQuality->new_L($l2resp);

is( $pwd_quality->quality(), "33", "Password quality test login");

my $lconn_id = blackbox2::ConnectionId->new_L($l2resp);

is ($lconn_id->connectionId(), "t:12345", "Login ConnectionId test");

my $pwdq_body ="<?xml version=\"1.0\" encoding=\"UTF-8\"?>
    <doc><password_quality>77</password_quality></doc>";

my $pwdq_resp = blackbox2::PwdQualityResp->new($pwdq_body);

my $pwd_quality2 = blackbox2::PasswordQuality->new($pwdq_resp);

is( $pwd_quality2->quality(), "77", "Password quality test");
