#!/usr/bin/python

# Utility script for testing Python binding
from testcommon import *

# Read custom request options from config file
def read_options ( opts, ctxt, path ) :
    for elem in ctxt.xpathEval(path) :
        if elem.prop("key") :
            opts.add( bb.Option( elem.prop("key"), elem.prop("val") ) )

# Read custom dbfields from config file
def read_dbfields ( ctxt, path ) :
    out = bb.DBFields()
    for elem in ctxt.xpathEval(path) :
        out.add( elem.getContent() )
    return out

# Read custom aliases from config file
def read_aliases ( ctxt, path ) :
    out = bb.OptAliases()
    for elem in ctxt.xpathEval(path) :
        out.add( elem.getContent() )
    return out

# Read custom attributes from config file
def read_attributes ( ctxt, path ) :
    out = bb.Attributes()
    for elem in ctxt.xpathEval(path) :
        out.add( elem.getContent() )
    return out


if __name__ == '__main__':
    if len(sys.argv) > 1 and sys.argv[1] :
        f = open( sys.argv[1] , 'r')
    else:
        f = sys.stdin

    config = f.read()

    doc = libxml2.parseDoc(config)
    ctxt = doc.xpathNewContext()

    # get common request options
    type   = xpath_get(ctxt, '/doc/type')
    uid    = xpath_get(ctxt, '/doc/uid')
    suid   = xpath_get(ctxt, '/doc/suid')
    sid    = xpath_get(ctxt, '/doc/sid')
    login  = xpath_get(ctxt, '/doc/login')
    userip = xpath_get(ctxt, '/doc/userip')

    if not type :
        print "Unknown test type."
        sys.exit(2)

    # get additional options
    opts = bb.Options()

    if xpath_exists (ctxt, '/doc/regname') :
        opts.add( bb.optRegname )

    if xpath_exists (ctxt, '/doc/email/getall') :
        opts.add( bb.optGetAllEmails )

    if xpath_exists (ctxt, '/doc/email/getyandex') :
        opts.add( bb.optGetYandexEmails )

    if xpath_exists (ctxt, '/doc/email/testone') :
        opts.add( bb.OptTestEmail( xpath_get(ctxt, '/doc/email/testone') ) )

    if xpath_exists (ctxt, '/doc/email/getdefault') :
        opts.add( bb.optGetDefaultEmail )

    if xpath_exists (ctxt, '/doc/aliases/getsocial') :
        opts.add( bb.optGetSocialAliases )

    if xpath_exists (ctxt, '/doc/ver2') :
        opts.add( bb.optVersion2 )

    if xpath_exists (ctxt, '/doc/authid') :
        opts.add( bb.optAuthId )

    if xpath_exists (ctxt, '/doc/multisession') :
        opts.add( bb.optMultisession )

    if xpath_exists (ctxt, '/doc/fullinfo') :
        opts.add( bb.optFullInfo )

    # get custom options
    read_options ( opts, ctxt, '/doc/option')

    # get dbfields
    opts.add( read_dbfields ( ctxt, '/doc/dbfield') )

    # get aliases
    opts.add( read_aliases ( ctxt, '/doc/aliases/alias') )

    if xpath_exists (ctxt, '/doc/aliases/all') :
        opts.add( bb.optGetAllAliases )

    # get attributes
    opts.add( read_attributes ( ctxt, '/doc/attribute') )

    # get login && session specific parameters
    password  = xpath_get(ctxt, '/doc/password')
    opt_auth  = xpath_get(ctxt, '/doc/authtype')
    sessionid = xpath_get(ctxt, '/doc/sessionid')
    hostname  = xpath_get(ctxt, '/doc/session_host')
    token     = xpath_get(ctxt, '/doc/token')

    # get reference request data
    ref_request = xpath_get(ctxt, '/doc/request')
    ref_body    = xpath_get(ctxt, '/doc/reqbody')

    # get mailhost specific parameters
    operation   = xpath_get(ctxt, '/doc/operation')
    scope       = xpath_get(ctxt, '/doc/scope')
    dbid        = xpath_get(ctxt, '/doc/dbid')
    priority    = xpath_get(ctxt, '/doc/priority')
    mx          = xpath_get(ctxt, '/doc/mx')
    olddbid     = xpath_get(ctxt, '/doc/olddbid')

    if type == "login" :
        if (not login and not uid) or not password :
            print "Bad login request parameters."
            sys.exit(2)

        if not uid:
            request = bb.LoginRequest( bb.LoginSid(login,sid), password,
                opt_auth, userip, opts)
        else :
            request = bb.LoginRequest( uid, password,
                opt_auth, userip, opts)

        if not match_uri ( request.uri, ref_request ) :
            sys.exit(1)

        if not match_data ( request.postdata, ref_body ) :
            sys.exit(1)
        sys.exit(0)

    if type == "info" :
        if uid :
            request = bb.InfoRequest(uid, userip, opts)
        elif login :
            request = bb.InfoRequest( bb.LoginSid(login,sid), userip, opts)
        elif suid :
            request = bb.InfoRequest( bb.SuidSid(suid,sid), userip, opts)
        else :
            if not xpath_exists( ctxt, "/doc/uids/uid" ):
              print "Bad info request data."
              sys.exit(2)
            uids = bb.UidsVector()
            uids.extend( xpath_get_all ( ctxt, "/doc/uids/uid") )
            request = bb.InfoRequest( uids, userip, opts)
    elif type == "session" :
        request = bb.SessionIDRequest( sessionid, hostname, userip, opts)
    elif type == "oauth" :
        request = bb.OAuthRequest( token, userip, opts)
    elif type == "mailhost":
        if not operation or not scope:
            print "Bad mailhost request parameters."
            sys.exit(2)
        if operation == "create":
          request = bb.MailHostCreateRequest(scope, dbid, priority, mx)
        elif operation == "delete":
          request = bb.MailHostDeleteRequest(scope, dbid)
        elif operation == "assign":
          request = bb.MailHostAssignRequest(scope, suid, dbid, olddbid)
        elif operation == "setprio":
          request = bb.MailHostSetPriorityRequest(scope, dbid, priority)
        elif operation == "find":
          request = bb.MailHostFindRequest(scope, priority)
        else:
          print "Unknown mailhost operation."
    elif type == "pwdquality" :
        request = bb.PwdQualityRequest( sessionid, hostname)
    else:
        request = ""

    if not match_uri ( request, ref_request ) :
        sys.exit(1)

    doc.freeDoc()
    ctxt.xpathFreeContext()

