#include <boost/python/def.hpp>
#include <boost/python/enum.hpp>
#include <boost/python/suite/indexing/vector_indexing_suite.hpp>
#include <boost/python/copy_const_reference.hpp>

#include "yandex/blackbox/blackbox2.h"
#include "python_response.h"

namespace py = boost::python;

namespace bb {

void register_accessors()
{
    // Regname
    py::class_<Regname, boost::noncopyable> regname ( "Regname", py::init<Response*>() );
    regname.add_property ( "value", py::make_function(&Regname::value, py::return_value_policy<py::copy_const_reference>() ));
    regname.def ( "__repr__", &Regname::operator const std::string&, py::return_value_policy<py::copy_const_reference>() );

    // Uid
    py::class_<Uid, boost::noncopyable> uid ( "Uid", py::init<Response*>() );
    uid.add_property ( "uid", py::make_function(&Uid::uid, py::return_value_policy<py::copy_const_reference>() ) );
    uid.add_property ( "hosted", &Uid::hosted );

    // LiteUid
    py::class_<LiteUid, boost::noncopyable> liteuid ( "LiteUid", py::init<Response*>() );
    liteuid.add_property ( "liteUid", py::make_function( &LiteUid::liteUid, py::return_value_policy<py::copy_const_reference>() ));
    liteuid.add_property ( "liteAccount", &LiteUid::liteAccount );

    // PDDUserInfo
    py::class_<PDDUserInfo, boost::noncopyable> pdd ( "PDDUserInfo", py::init<Response*>() );
    pdd.add_property ( "domId", py::make_function( &PDDUserInfo::domId, py::return_value_policy<py::copy_const_reference>() ));
    pdd.add_property ( "domain", py::make_function( &PDDUserInfo::domain, py::return_value_policy<py::copy_const_reference>() ));
    pdd.add_property ( "mx", py::make_function( &PDDUserInfo::mx, py::return_value_policy<py::copy_const_reference>() ));
    pdd.add_property ( "domEna", py::make_function( &PDDUserInfo::domEna, py::return_value_policy<py::copy_const_reference>() ));
    pdd.add_property ( "catchAll", py::make_function( &PDDUserInfo::catchAll, py::return_value_policy<py::copy_const_reference>() ));

    // KarmaInfo
    py::class_<KarmaInfo, boost::noncopyable> karma ( "KarmaInfo", py::init<Response*>() );
    karma.add_property ( "karma", py::make_function( &KarmaInfo::karma, py::return_value_policy<py::copy_const_reference>() ));
    karma.add_property ( "banTime", py::make_function( &KarmaInfo::banTime, py::return_value_policy<py::copy_const_reference>() ));
    karma.add_property ( "karmaStatus", py::make_function( &KarmaInfo::karmaStatus, py::return_value_policy<py::copy_const_reference>() ));

    // DisplayNameInfo
    py::class_<DisplayNameInfo, boost::noncopyable> dinfo ( "DisplayNameInfo", py::init<Response*>() );
    dinfo.add_property ( "name", py::make_function( &DisplayNameInfo::name, py::return_value_policy<py::copy_const_reference>() ));
    dinfo.add_property ( "social", &DisplayNameInfo::social );
    dinfo.add_property ( "socProfile", py::make_function( &DisplayNameInfo::socProfile, py::return_value_policy<py::copy_const_reference>() ));
    dinfo.add_property ( "socProvider", py::make_function( &DisplayNameInfo::socProvider, py::return_value_policy<py::copy_const_reference>() ));
    dinfo.add_property ( "socTarget", py::make_function( &DisplayNameInfo::socTarget, py::return_value_policy<py::copy_const_reference>() ));
    dinfo.add_property ( "defaultAvatar", py::make_function( &DisplayNameInfo::defaultAvatar, py::return_value_policy<py::copy_const_reference>() ));

    // LoginInfo
    py::class_<LoginInfo, boost::noncopyable> linfo ( "LoginInfo", py::init<Response*>() );
    linfo.add_property ( "login", py::make_function( &LoginInfo::login, py::return_value_policy<py::copy_const_reference>() ));
    linfo.add_property ( "have_password", &LoginInfo::havePassword );
    linfo.add_property ( "have_hint", &LoginInfo::haveHint );

    // EmailList
    py::class_<EmailList::Item> email_item ( "EmailItem" );
    email_item.add_property ( "address", py::make_function( &EmailList::Item::address, py::return_value_policy<py::copy_const_reference>() ));
    email_item.add_property ( "date", py::make_function( &EmailList::Item::date, py::return_value_policy<py::copy_const_reference>() ));
    email_item.add_property ( "native", &EmailList::Item::native );
    email_item.add_property ( "validated", &EmailList::Item::validated );
    email_item.add_property ( "default", &EmailList::Item::isDefault );
    email_item.add_property ( "rpop", &EmailList::Item::rpop );

    py::class_< std::vector<EmailList::Item> > email_item_vec ( "EmailItemVec" );
    email_item_vec.def ( py::vector_indexing_suite< std::vector<EmailList::Item> >() );

    py::class_<EmailList, boost::noncopyable> email_list ( "EmailList", py::init<Response*>() );
    email_list.def ( "empty", &EmailList::empty );
    email_list.def ( "size", &EmailList::size );
    email_list.def ( "getDefault", &EmailList::getDefault, py::return_value_policy<py::copy_const_reference>() );
    email_list.def ( "getEmailItems", &EmailList::getEmailItems, py::return_value_policy<py::copy_const_reference>() );

    // NewSessionId
    py::class_<NewSessionId, boost::noncopyable> newid ( "NewSessionId", py::init<SessionResp*>() );
    newid.def(py::init<MultiSessionResp*>());
    newid.add_property ( "value", py::make_function( &NewSessionId::value, py::return_value_policy<py::copy_const_reference>() ));
    newid.add_property ( "domain", py::make_function( &NewSessionId::domain, py::return_value_policy<py::copy_const_reference>() ));
    newid.add_property ( "expires", py::make_function( &NewSessionId::expires, py::return_value_policy<py::copy_const_reference>() ));
    newid.add_property ( "httpOnly", &NewSessionId::httpOnly);
    newid.def ( "__repr__", &NewSessionId::operator const std::string&, py::return_value_policy<py::copy_const_reference>() );

    // AuthInfo
    py::class_<AuthInfo, boost::noncopyable> ainfo ( "AuthInfo", py::init<SessionResp*>() );
    ainfo.add_property ( "social", &AuthInfo::social );
    ainfo.add_property ( "age", py::make_function( &AuthInfo::age, py::return_value_policy<py::copy_const_reference>() ));
    ainfo.add_property ( "profileId", py::make_function( &AuthInfo::profileId, py::return_value_policy<py::copy_const_reference>() ));
    ainfo.add_property ( "secure", &AuthInfo::secure );

    // AllowMoreUsers
    py::class_<AllowMoreUsers, boost::noncopyable> allow_more ( "AllowMoreUsers", py::init<MultiSessionResp*>() );
    allow_more.add_property ( "allowMoreUsers", &AllowMoreUsers::allowMoreUsers);

    // AliasList
    py::enum_<AliasList::Item::Type> alias_type ( "AliasType" );
    alias_type.value ( "Login",         AliasList::Item::Login );
    alias_type.value ( "Portal",        AliasList::Item::Portal );
    alias_type.value ( "Mail",          AliasList::Item::Mail );
    alias_type.value ( "NarodMail",     AliasList::Item::NarodMail );
    alias_type.value ( "Lite",          AliasList::Item::Lite );
    alias_type.value ( "Social",        AliasList::Item::Social );
    alias_type.value ( "PDD",           AliasList::Item::PDD );
    alias_type.value ( "PDDAlias",      AliasList::Item::PDDAlias );
    alias_type.value ( "AltDomain",     AliasList::Item::AltDomain );
    alias_type.value ( "Phonish",       AliasList::Item::Phonish );
    alias_type.value ( "PhoneNumber",   AliasList::Item::PhoneNumber );
    alias_type.value ( "Mailish",       AliasList::Item::Mailish );
    alias_type.value ( "Yandexoid",     AliasList::Item::Yandexoid );
    alias_type.value ( "KinopoiskId",   AliasList::Item::KinopoiskId );

    py::class_<AliasList::Item> alias_item ( "AliasItem" );
    alias_item.add_property ( "type", &AliasList::Item::type );
    alias_item.add_property ( "alias", py::make_function( &AliasList::Item::alias, py::return_value_policy<py::copy_const_reference>() ));

    py::class_< std::vector<AliasList::Item> > alias_item_vec ( "AliasItemVec" );
    alias_item_vec.def ( py::vector_indexing_suite< std::vector<AliasList::Item> >() );

    py::class_<AliasList, boost::noncopyable> alias_list ( "AliasList", py::init<Response*>() );
    alias_list.def ( "empty", &AliasList::empty );
    alias_list.def ( "size", &AliasList::size );
    alias_list.def ( "getAliases", &AliasList::getAliases, py::return_value_policy<py::copy_const_reference>() );

    // MailHostsList
    py::class_<MailHostsList::Item> host_item ( "MailHostItem" );
    host_item.add_property ( "hostId", py::make_function( &MailHostsList::Item::hostId, py::return_value_policy<py::copy_const_reference>() ));
    host_item.add_property ( "hostIp", py::make_function( &MailHostsList::Item::hostIp, py::return_value_policy<py::copy_const_reference>() ));
    host_item.add_property ( "hostName", py::make_function( &MailHostsList::Item::hostName, py::return_value_policy<py::copy_const_reference>() ));
    host_item.add_property ( "dbId", py::make_function( &MailHostsList::Item::dbId, py::return_value_policy<py::copy_const_reference>() ));
    host_item.add_property ( "sid", py::make_function( &MailHostsList::Item::sid, py::return_value_policy<py::copy_const_reference>() ));
    host_item.add_property ( "priority", py::make_function( &MailHostsList::Item::priority, py::return_value_policy<py::copy_const_reference>() ));
    host_item.add_property ( "mx", py::make_function( &MailHostsList::Item::mx, py::return_value_policy<py::copy_const_reference>() ));

    py::class_< std::vector<MailHostsList::Item> > host_item_vec ( "MailHostItemVec" );
    host_item_vec.def ( py::vector_indexing_suite< std::vector<MailHostsList::Item> >() );

    py::class_<MailHostsList, boost::noncopyable> host_list ( "MailHostsList", py::init<HostResp*>() );
    host_list.def ( "empty", &MailHostsList::empty );
    host_list.def ( "size", &MailHostsList::size );
    host_list.def ( "getHosts", &MailHostsList::getHosts, py::return_value_policy<py::copy_const_reference>() );

    // OAuthInfo
    py::class_< std::map<std::string,std::string> > map_str_str ( "MapStrStr" );
    map_str_str.def ( "__iter__", py::iterator< std::map<std::string,std::string> >() );

    py::class_<OAuthInfo, boost::noncopyable> oauthinfo ( "OAuthInfo", py::init<SessionResp*>() );
    oauthinfo.def ( "empty", &OAuthInfo::empty );
    oauthinfo.def ( "size", &OAuthInfo::size );
    oauthinfo.def ( "getInfo", &OAuthInfo::getInfo, py::return_value_policy<py::copy_const_reference>() );

    // BruteforcePolicy
    py::enum_<BruteforcePolicy::Mode> bfpolicy_mode ( "ResistMode" );
    bfpolicy_mode.value ( "None", BruteforcePolicy::None );
    bfpolicy_mode.value ( "Captcha", BruteforcePolicy::Captcha );
    bfpolicy_mode.value ( "Delay", BruteforcePolicy::Delay );
    bfpolicy_mode.value ( "Expired", BruteforcePolicy::Expired );

    py::class_<BruteforcePolicy, boost::noncopyable> bfpolicy ( "BruteforcePolicy", py::init<LoginResp*>() );
    bfpolicy.add_property ( "mode", &BruteforcePolicy::mode );
    bfpolicy.add_property ( "delay", &BruteforcePolicy::delay );

    // SessionKind
    py::enum_<SessionKind::Kind> skind ( "SessKind" );
    skind.value ( "None", SessionKind::None );
    skind.value ( "Support", SessionKind::Support );
    skind.value ( "Stress", SessionKind::Stress );

    py::class_<SessionKind, boost::noncopyable> session_kind ( "SessionKind", py::init<SessionResp*>() );
    session_kind.def ( py::init<MultiSessionResp*>() );
    session_kind.add_property ( "kind", &SessionKind::kind );
    session_kind.add_property ( "kindName", py::make_function( &SessionKind::kindName, py::return_value_policy<py::copy_const_reference>() ) );

    // AuthId
    py::class_<AuthId, boost::noncopyable> auth_id ( "AuthId", py::init<SessionResp*>() );
    auth_id.def ( py::init<MultiSessionResp*>() );
    auth_id.add_property ( "time", py::make_function( &AuthId::time, py::return_value_policy<py::copy_const_reference>() ) );
    auth_id.add_property ( "userIp", py::make_function( &AuthId::userIp, py::return_value_policy<py::copy_const_reference>() ) );
    auth_id.add_property ( "hostId", py::make_function( &AuthId::hostId, py::return_value_policy<py::copy_const_reference>() ) );
    auth_id.add_property ( "authId", py::make_function( &AuthId::authId, py::return_value_policy<py::copy_const_reference>() ) );
    auth_id.def ( "__repr__", &AuthId::operator const std::string&, py::return_value_policy<py::copy_const_reference>() );

    // PasswordQuality
    py::class_<PasswordQuality, boost::noncopyable> pwd_quality ( "PasswordQuality", py::init<LoginResp*>() );
    pwd_quality.def( py::init<PwdQualityResp*>() );
    pwd_quality.add_property ( "quality", py::make_function( &PasswordQuality::quality, py::return_value_policy<py::copy_const_reference>() ));
    pwd_quality.def ( "__repr__", &PasswordQuality::operator const std::string&, py::return_value_policy<py::copy_const_reference>() );

    // ConnectionId
    py::class_<ConnectionId, boost::noncopyable> connection_id ( "ConnectionId", py::init<LoginResp*>() );
    connection_id.def ( py::init<SessionResp*>() );
    connection_id.def ( py::init<MultiSessionResp*>() );
    connection_id.add_property ( "connectionId", py::make_function( &ConnectionId::connectionId, py::return_value_policy<py::copy_const_reference>() ));
    connection_id.def ( "__repr__", &ConnectionId::operator const std::string&, py::return_value_policy<py::copy_const_reference>() );

}

} // namespace bb

// vi: expandtab:sw=4:ts=4
// kate: replace-tabs on; indent-width 4; tab-width 4;
