#include <boost/python/init.hpp>
#include <boost/python/scope.hpp>
#include <boost/python/copy_const_reference.hpp>
#include <boost/python/return_value_policy.hpp>
#include <boost/python/return_internal_reference.hpp>
#include <boost/python/iterator.hpp>


#include "yandex/blackbox/blackbox2.h"
#include "python_response.h"

namespace py = boost::python;

namespace bb {

void register_options()
{
    // class Option
    py::class_<Option> opt ( "Option", "Single blackbox request option",
                             py::init<std::string,std::string>() );
    opt.def ( "key", &Option::key, py::return_value_policy<py::copy_const_reference>() );
    opt.def ( "val", &Option::val, py::return_value_policy<py::copy_const_reference>() );

    // common option constants
    py::scope().attr ( "optRegname" ) = optRegname;
    py::scope().attr ( "optAuthId" ) = optAuthId;
    py::scope().attr ( "optFullInfo" ) = optFullInfo;

    py::scope().attr ( "optVersion2" ) = optVersion2;
    py::scope().attr ( "optMultisession" ) = optMultisession;

    py::scope().attr ( "optGetSocialAliases" ) = optGetSocialAliases;
    py::scope().attr ( "optGetAllAliases" ) = optGetAllAliases;

    py::scope().attr ( "optGetAllEmails" ) = optGetAllEmails;
    py::scope().attr ( "optGetYandexEmails" ) = optGetYandexEmails;
    py::scope().attr ( "optGetDefaultEmail" ) = optGetDefaultEmail;

    // class Options
    Options& ( *out_db ) ( Options& , const DBFields& ) = operator<<;
    Options& ( *out_testemail ) ( Options& , const OptTestEmail& ) = operator<<;
    Options& ( *out_alias ) ( Options& , const OptAliases& ) = operator<<;
    Options& ( *out_attribute ) ( Options& , const Attributes& ) = operator<<;

    py::class_<Options> reg ( "Options", "List of blackbox request options", py::init<>() );
    reg.def ( py::init<Option>() );
    reg.def ( "add", &Options::operator<<, py::return_internal_reference<>() );
    reg.def ( "add", out_db, py::return_internal_reference<>() );
    reg.def ( "add", out_testemail, py::return_internal_reference<>() );
    reg.def ( "add", out_alias, py::return_internal_reference<>() );
    reg.def ( "add", out_attribute, py::return_internal_reference<>() );

    py::scope().attr ( "optNone" ) = optNone;

    // class OptTestEmail
    py::class_<OptTestEmail> testEmail ( "OptTestEmail", "Test one email option",
                                         py::init<std::string>() );
    testEmail.def ( "format", &OptTestEmail::format, py::return_internal_reference<>() );

    // class DBFields
    py::class_<DBFields> dbfields ( "DBFields", "Additional DB fields to retrieve" );
    dbfields.def ( py::init<std::string>() );
    dbfields.def ( py::init<Response*>() );
    dbfields.def ( "readResponse", &DBFields::readResponse );
    dbfields.def ( "empty", &DBFields::empty );
    dbfields.def ( "size",  &DBFields::size );
    dbfields.def ( "clear", &DBFields::clear );
    dbfields.def ( "clearValues", &DBFields::clearValues );
    dbfields.def ( "add", &DBFields::operator<<, py::return_internal_reference<>() );
    dbfields.def ( "get", &DBFields::get, py::return_value_policy<py::copy_const_reference>() );
    dbfields.def ( "Options", &DBFields::operator Options );
    dbfields.def ( "__iter__", py::iterator<const DBFields>() );

    py::class_< std::pair<const std::string,std::string> > pair ( "Pair", "std::pair<const string,string>" );
    pair.def_readonly ( "key", &std::pair<const std::string,std::string>::first );
    pair.def_readonly ( "val", &std::pair<const std::string,std::string>::second );

    // class OptAliases
    py::class_<OptAliases> optaliases ( "OptAliases", "Additional aliases to retrieve" );
    optaliases.def ( py::init<std::string>() );
    optaliases.def ( "add", &OptAliases::operator<<, py::return_internal_reference<>() );
    optaliases.def ( "Options", &OptAliases::operator Options );

    // class Attributes
    py::class_<Attributes> attributes ( "Attributes", "Additional attributes to retrieve" );
    attributes.def ( py::init<std::string>() );
    attributes.def ( py::init<Response*>() );
    attributes.def ( "readResponse", &Attributes::readResponse );
    attributes.def ( "empty", &Attributes::empty );
    attributes.def ( "size",  &Attributes::size );
    attributes.def ( "clear", &Attributes::clear );
    attributes.def ( "clearValues", &Attributes::clearValues );
    attributes.def ( "add", &Attributes::operator<<, py::return_internal_reference<>() );
    attributes.def ( "get", &Attributes::get, py::return_value_policy<py::copy_const_reference>() );
    attributes.def ( "Options", &Attributes::operator Options );
    attributes.def ( "__iter__", py::iterator<const Attributes>() );

}

} // namespace bb

// vi: expandtab:sw=4:ts=4
// kate: replace-tabs on; indent-width 4; tab-width 4;
