#include "python_response.h"

#include "../src/utils.h"

#include <sstream>

namespace bb {

  Response* Python_InfoResponse (const std::string& response)
  {
    return InfoResponse(response).release();
  }

  BulkResponse* Python_BulkResponse (const std::string& response)
  {
    return InfoResponseBulk(response).release();
  }

  LoginResp* Python_LoginResponse (const std::string& response)
  {
    return LoginResponse(response).release();
  }

  SessionResp* Python_SessionIDResponse (const std::string& response)
  {
    return SessionIDResponse(response).release();
  }

  MultiSessionResp* Python_SessionIDResponseMulti (const std::string& response)
  {
    return SessionIDResponseMulti(response).release();
  }

  HostResp* Python_HostResponse (const std::string& response)
  {
    return MailHostResponse(response).release();
  }

  PwdQualityResp* Python_PwdQualityResponse (const std::string& response)
  {
    return PwdQualityResponse(response).release();
  }


  std::string printInfoResponse (const Response* resp)
  {
    std::ostringstream out;
    out << resp;
    return out.str();
  }

  std::string printBulkResponse (const BulkResponse* resp)
  {
    std::ostringstream out;
    out << resp;
    return out.str();
  }

  std::string printLoginResponse (const LoginResp* resp)
  {
    std::ostringstream out;
    out << resp;
    return out.str();
  }

  std::string printSessionResponse (const SessionResp* resp)
  {
    std::ostringstream out;
    out << resp;
    return out.str();
  }

  std::string printMultiSessionResponse (const MultiSessionResp* resp)
  {
    std::ostringstream out;
    out << resp;
    return out.str();
  }

  std::string printHostResponse (const HostResp* resp)
  {
    std::ostringstream out;
    out << resp;
    return out.str();
  }

  std::string printPwdQualityResponse (const PwdQualityResp* resp)
  {
    std::ostringstream out;
    out << resp;
    return out.str();
  }

} // namespace bb

