#ifndef AUTH_PYTHON_RESPONSE_H_INCLUDED
#define AUTH_PYTHON_RESPONSE_H_INCLUDED

#include <boost/shared_ptr.hpp>
#include "yandex/blackbox/blackbox2.h"

#include <string>

namespace bb {

  /// Python wrapper for InfoResponse
  Response* Python_InfoResponse (const std::string& response);

  /// Python wrapper for BulkResponse
  BulkResponse* Python_BulkResponse (const std::string& response);

  /// Python wrapper for LoginResponse
  LoginResp* Python_LoginResponse (const std::string& response);

  /// Python wrapper for SessionResponse
  SessionResp* Python_SessionIDResponse (const std::string& response);

  /// Python wrapper for SessionResponseMulti
  MultiSessionResp* Python_SessionIDResponseMulti (const std::string& response);

  /// Python wrapper for HostResponse
  HostResp* Python_HostResponse (const std::string& response);

  /// Python wrapper for PwdQualityResponse
  PwdQualityResp* Python_PwdQualityResponse (const std::string& response);

  /// Return contents of Response in human-readable form
  std::string printInfoResponse (const Response* resp);

  /// Return contents of BulkResponse in human-readable form
  std::string printBulkResponse (const BulkResponse* resp);

  /// Return contents of LoginResp in human-readable form
  std::string printLoginResponse (const LoginResp* resp);

  /// Return contents of SessionResp in human-readable form
  std::string printSessionResponse (const SessionResp* resp);

  /// Return contents of MultiSessionResp in human-readable form
  std::string printMultiSessionResponse (const MultiSessionResp* resp);

  /// Return contents of HostResp in human-readable form
  std::string printHostResponse (const HostResp* resp);

  /// Return contents of PwdQualityResp in human-readable form
  std::string printPwdQualityResponse (const PwdQualityResp* resp);

} // namespace bb

#endif // AUTH_PYTHON_RESPONSE_H_INCLUDED

