include(find_blackbox2_dependencies)

if(BLACKBOX2_FOUND)
  set(BLACKBOX2_FIND_QUIETLY TRUE)
endif()

find_path(BLACKBOX2_INCLUDE_DIR
  NAMES yandex/blackbox/blackbox2.h
  HINTS ${CMAKE_INSTALL_PREFIX}/include)

find_library(BLACKBOX2_LIBRARY
  NAMES blackbox2
  HINTS ${CMAKE_INSTALL_PREFIX}
  PATH_SUFFIXES .libs lib lib64)

find_blackbox2_dependencies()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(BLACKBOX2 DEFAULT_MSG
  BLACKBOX2_INCLUDE_DIR BLACKBOX2_LIBRARY)

if(BLACKBOX2_FOUND)
  list(APPEND BLACKBOX2_INCLUDE_DIR ${BLACKBOX2_DEPENDENCY_INCLUDE_DIRS})
  list(APPEND BLACKBOX2_LIBRARIES ${BLACKBOX2_LIBRARY} ${BLACKBOX2_DEPENDENCY_LIBRARIES})
endif()

mark_as_advanced(BLACKBOX2_INCLUDE_DIR BLACKBOX2_LIBRARIES)
