#pragma once
#ifndef CURLWRAPPER_H_INCLUDED
#define CURLWRAPPER_H_INCLUDED

#include <curl/curl.h>

#include "yandex/auth/blackbox2.h"

namespace bb {

    using namespace std;

    class CUrl
    {
    public:
        static CUrl& get()
        {
            return instance_;
        }

        string URLEncode (const string& str)
        {
            CUrlAutoPtr p( curl_easy_escape(pHandle_, str.c_str(), str.size()) );
            if ( !p.get() )
                throw FatalError( NSessionCodes::UNKNOWN, "curl_easy_escape failed");

            return string(p.get());
        }

        string URLDecode (const string& str)
        {
            int len;
            CUrlAutoPtr p( curl_easy_unescape(pHandle_, str.c_str(), str.size(), &len) );
            if ( !p.get() )
                throw FatalError( NSessionCodes::UNKNOWN, "curl_easy_unescape failed");

            return string(p.get(), len);
        }

    private:

        CUrl()
        {
            pHandle_ = curl_easy_init();
            if ( !pHandle_ )
                throw FatalError( NSessionCodes::UNKNOWN, "curl_easy_init failed");
        }

        ~CUrl()
        {
            curl_easy_cleanup (pHandle_);
        }

        class CUrlAutoPtr
        {
        public:
            CUrlAutoPtr (char *p) : p_ (p) {}
            ~CUrlAutoPtr () { if ( p_ ) curl_free (p_); }

            const char *get () const { return p_; }

        private:
            char* p_;
        };

        CURL* pHandle_;
        static CUrl instance_;
    };

}   // namespace bb

#endif  // CURLWRAPPER_H_INCLUDED

// vi: expandtab:sw=4:ts=4
// kate: replace-tabs on; indent-width 4; tab-width 4;
