#include "responseimpl.h"
#include "initexc.h"
#include <iostream>
#include <string>

namespace bb {
Response::Impl::Impl(const std::string& response)
{
    xmlroot_.reset(new xmlConfig::XConfig(false));
    if( xmlroot_->Parse(response) ) {
        throw FatalError( NSessionCodes::UNKNOWN,
                          "Failed to parse blackbox response: " + response
                        );
    }
    try {
        doc_.reset(new xmlConfig::Part(xmlroot_->GetFirst("/doc")));
    } catch (initexc e) {
        throw FatalError( NSessionCodes::UNKNOWN,
                          "Missing root <doc> node: " + response
        );
    }
}

Response::Impl::Impl(const xmlConfig::Part* part)
{
    if (!part)
        throw FatalError( NSessionCodes::UNKNOWN,
                          "Unable to create response from NULL XML part"
        );

    doc_.reset(new xmlConfig::Part(*part));
}

Response::Impl::~Impl() {
}

bool Response::Impl::getIfExists(const std::string& xpath, std::string& variable)
{
    return doc_->GetIfExists(xpath.c_str(), variable);
}

bool Response::Impl::getIfExists(const std::string& xpath, long int& variable)
{
    return doc_->GetIfExists(xpath.c_str(), variable);
}

xmlConfig::Parts Response::Impl::getParts(const std::string& xpath)
{
    return doc_->GetParts(xpath.c_str());
}


}    // namespace bb

// vi: expandtab:sw=4:ts=4
// kate: replace-tabs on; indent-width 4; tab-width 4;
