#ifndef RESPONSEIMPL_H_INCLUDED
#define RESPONSEIMPL_H_INCLUDED

#include "yandex/blackbox/blackbox2.h"
#include "xconfig.h"
#include <memory>

namespace bb {

    /// XML document wrapper
    class Response::Impl {
    public:
        // init by full xml document
        Impl(const std::string& response);
        // init by document part
        Impl(const xmlConfig::Part* part);

        virtual ~Impl();

        bool getIfExists(const std::string& xpath, std::string& variable);
        bool getIfExists(const std::string& xpath, long int& variable);
        xmlConfig::Parts getParts(const std::string& xpath);

    protected:
        std::auto_ptr<xmlConfig::XConfig> xmlroot_;
        std::auto_ptr<xmlConfig::Part> doc_;
    };

}   // namespace bb

#endif  // RESPONSEIMPL_H_INCLUDED

// vi: expandtab:sw=4:ts=4
// kate: replace-tabs on; indent-width 4; tab-width 4;
