#pragma once
#ifndef UTILS_H_INCLUDED
#define UTILS_H_INCLUDED

#include <string>
#include <iostream>
#include <algorithm>
#include <functional>

#include "yandex/blackbox/blackbox2.h"

namespace bb {
    using namespace std;

    const unsigned MAX_REQUEST_LENGTH = 1024;

    string URLEncode (const string& str);

    string URLDecode (const string& str);

    std::string bin2base64url(const char* buf, size_t len, bool pad=false);
    std::string bin2base64url(const std::string& buf, bool pad=false);

    std::string base64url2bin(const char* buf, size_t len);
    std::string base64url2bin(const std::string& buf);

    std::string HMAC_sha256(const std::string& key, const char* data, size_t dataLen);
    std::string HMAC_sha256(const std::string& key, const std::string& data);

    class RequestBuilder {
        string request_;
    public:
        RequestBuilder (const string& method);

        void add (const string& key, const string& val);
        void add (const string& key, const vector<string>& values);
        void add (const Option& opt);
        void add (const Options& options);

        operator string() { return request_; }
    };

    // Human-readable output of enumerations
    std::ostream& operator<< (std::ostream& out, LoginResp::Status s);
    std::ostream& operator<< (std::ostream& out, LoginResp::AccountStatus s);
    std::ostream& operator<< (std::ostream& out, LoginResp::PasswdStatus s);
    std::ostream& operator<< (std::ostream& out, SessionResp::Status s);
    std::ostream& operator<< (std::ostream& out, HostResp::Status s);
    std::ostream& operator<< (std::ostream& out, AliasList::Item::Type t);
    std::ostream& operator<< (std::ostream& out, NSessionCodes::ESessionError e);
    std::ostream& operator<< (std::ostream& out, BruteforcePolicy::Mode m);
    std::ostream& operator<< (std::ostream& out, SessionKind::Kind k);

    // Human-readable output of list items
    std::ostream& operator<< (std::ostream& out, const EmailList::Item& item);
    std::ostream& operator<< (std::ostream& out, const AliasList::Item& item);
    std::ostream& operator<< (std::ostream& out, const MailHostsList::Item& item);
    std::ostream& operator<< (std::ostream& out,
                              const std::pair<std::string,std::string>& item);

    std::ostream& operator<< (std::ostream& out, const EmailList& data);
    std::ostream& operator<< (std::ostream& out, const AliasList& data);
    std::ostream& operator<< (std::ostream& out, const DBFields& data);
    std::ostream& operator<< (std::ostream& out, const Attributes& data);
    std::ostream& operator<< (std::ostream& out, const MailHostsList& data);
    std::ostream& operator<< (std::ostream& out, const OAuthInfo& data);

    // Human-readable output of all known Response information
    std::ostream& operator<< (std::ostream& out, const Response* pResp);
    std::ostream& operator<< (std::ostream& out, const BulkResponse* pBulkResp);
    std::ostream& operator<< (std::ostream& out, const LoginResp* pLogResp);
    std::ostream& operator<< (std::ostream& out, const SessionResp* pSessResp);
    std::ostream& operator<< (std::ostream& out, const MultiSessionResp* pMultiSessResp);
    std::ostream& operator<< (std::ostream& out, const HostResp* pHostResp);
    std::ostream& operator<< (std::ostream& out, const PwdQualityResp* pPwdQualityResp);

    // Human-readable output for response data structures
    std::ostream& operator<< (std::ostream& out, const PDDUserInfo& info);
    std::ostream& operator<< (std::ostream& out, const KarmaInfo& info);
    std::ostream& operator<< (std::ostream& out, const DisplayNameInfo& info);
    std::ostream& operator<< (std::ostream& out, const AuthInfo& info);

}   // namespace bb


namespace idn {

    // Note: all encode/decode functions return reference to original string if no transformation needed

    // encode entire string to punycode
    const std::string& encode(const std::string& str, std::string& converted);

    // decode entire string as punycode
    const std::string& decode(const std::string& str, std::string& converted);

    // encode address to punycode
    const std::string& encodeAddr(const std::string& addr, std::string& converted);

    // decode address as punycode
    const std::string& decodeAddr(const std::string& addr, std::string& converted);


    inline void to_lower(std::string &inplace)
    {
        std::transform(inplace.begin(), inplace.end(), inplace.begin(), tolower);
    }


} // namespace idn


#endif // UTILS_H_INCLUDED

// vi: expandtab:sw=4:ts=4
// kate: replace-tabs on; indent-width 4; tab-width 4;
