#ifndef _HOSTSEARCH_HPP_
#define _HOSTSEARCH_HPP_

#include <string>
#include <iostream>
#include <vector>

namespace hostsearch {

// NamedNetworkIterator: forward iterator, value should be named_network;
// HostIterator: forward iterator, value shold be std::string;
// Hosts can be ip addresses or urls. Resolving to ip addresses will be
//   performed synchronously.
template <class NamedNetworkIterator, class HostIterator>
HostIterator find(NamedNetworkIterator network_begin,
        NamedNetworkIterator network_end,
        HostIterator host_begin,
        HostIterator host_end);

// Networks is in the following format: [ip prefix name]
// Hosts is in the following format: [url]
// Returns and empty string if nothing found;
inline std::string find(std::istream& networks, std::istream& hosts);


// Reads networks and hosts from files
inline std::string find(const char* networks_filename,
    const char* hosts_filename);


// NamedNetworksRange: value should be named_network;
// HostsRange: value shold be std::string;
// Handler: function or function object that accept two args - named_network and std::string
// Hosts can be ip addresses or urls. Resolving to ip addresses will be
//   performed synchronously.
// Applies handler to network-host pair every time host belongs to network
template <class NamedNetworksRange, class HostsRange, typename Handler>
void associate_core(const NamedNetworksRange& networks,
        const HostsRange& hosts,
        Handler handle);

// Networks is in the following format: [ip prefix name]
// Hosts is in the following format: [url]
template <typename Handler>
void associate(std::istream& networks, std::istream& hosts, Handler handle);

// Reads networks and hosts from files
template <typename Handler>
void associate(const char* networks_filename,
        const char* hosts_filename,
        Handler handle);


// Removes reduntdant records;
// Example:
// In:   77.88.60.0 23 ugr
//       77.88.60.0 25 ugr
// Out:  77.88.60.0 23 ugr
template <class NamedNetworkIterator>
typename std::vector<NamedNetworkIterator> canonize_namednetworks(
  NamedNetworkIterator beg, NamedNetworkIterator end);

inline std::string canonize_namednetworks(std::istream& networks);

inline std::string canonize_namednetworks(const char* networks_filename);

} // namespace hostsearch {

#include "detail/hostsearch.ipp"

#endif /* _HOSTSEARCH_HPP_ */
