#ifndef _HOSTSEARCH_NETWORK_
#define _HOSTSEARCH_NETWORK_

#include <boost/asio.hpp>

namespace hostsearch {

struct network
{
  network(const boost::asio::ip::address& addr, int bits)
    : ip(addr)
    , prefix_bits(bits)
  {}

  network()
  {}

  boost::asio::ip::address ip;
  int prefix_bits;
};

typedef std::pair<std::string, network> named_network;

} // namespace hostsearch {

#endif /* _HOSTSEARCH_NETWORK_ */
