package ru.yandex.cache.async;

import com.googlecode.concurrentlinkedhashmap.Weigher;

public class ArrayWeigher<T> implements Weigher<T[]> {
    private final Weigher<? super T> weigher;

    public ArrayWeigher(final Weigher<? super T> weigher) {
        this.weigher = weigher;
    }

    @Override
    public int weightOf(final T[] values) {
        int sum = ConcurrentLinkedHashMapAsyncStorage.OBJECT_WEIGHT
            * (values.length + 1);
        for (T value: values) {
            sum += weigher.weightOf(value);
        }
        return sum;
    }
}

