package ru.yandex.cache.async;

import java.util.logging.Logger;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.concurrent.TimeFrameQueue;
import ru.yandex.http.util.AbstractFilterFutureCallback;

public class AsyncCacheResultCallback<V>
    extends AbstractFilterFutureCallback<AsyncCacheResult<V>, V>
{
    private final Logger logger;
    private final TimeFrameQueue<? super AsyncCacheResultType> cacheResults;

    public AsyncCacheResultCallback(
        final FutureCallback<? super V> callback,
        final Logger logger,
        final TimeFrameQueue<? super AsyncCacheResultType> cacheResults)
    {
        super(callback);
        this.logger = logger;
        this.cacheResults = cacheResults;
    }

    @Override
    public void completed(final AsyncCacheResult<V> result) {
        callback.completed(result.value());
        logger.fine("Cache result type: " + result.type());
        cacheResults.accept(result.type());
    }
}

