package ru.yandex.cache.async;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.function.GenericAutoCloseable;

public interface AsyncStorage<K, V, E extends Exception>
    extends GenericAutoCloseable<E>
{
    void get(K key, FutureCallback<? super V> callback);

    void put(K key, V value, long ttl, FutureCallback<Void> callback);
}

