package ru.yandex.cache.async;

import ru.yandex.stater.GolovanChart;
import ru.yandex.stater.GolovanChartGroup;
import ru.yandex.stater.GolovanPanel;
import ru.yandex.stater.ImmutableGolovanPanelConfig;
import ru.yandex.stater.Stater;
import ru.yandex.stater.StatsConsumer;
import ru.yandex.util.string.StringUtils;

public class ConcurrentLinkedHashMapAsyncStorageStater implements Stater {
    private final ConcurrentLinkedHashMapAsyncStorage<?, ?> storage;
    private final boolean averageSizeChart;
    private final String prefix;
    private final String category;
    private final String title;
    private final String elementCountSignal;
    private final String weightedSizeSignal;

    public ConcurrentLinkedHashMapAsyncStorageStater(
        final ConcurrentLinkedHashMapAsyncStorage<?, ?> storage,
        final boolean averageSizeChart,
        final String prefix,
        final String category,
        final String title)
    {
        this.storage = storage;
        this.averageSizeChart = averageSizeChart;
        this.prefix = prefix;
        this.category = category;
        this.title = title;
        elementCountSignal = prefix + "cache-element-count_ammm";
        weightedSizeSignal = prefix + "cache-weighted-size_ammm";
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        statsConsumer.stat(elementCountSignal, storage.size());
        statsConsumer.stat(weightedSizeSignal, storage.weightedSize());
    }

    @Override
    public void addToGolovanPanel(
        final GolovanPanel panel,
        final String statsPrefix)
    {
        String prefix = StringUtils.removeSuffix(this.prefix, '-');
        String chartsPrefix = statsPrefix + prefix;
        GolovanChartGroup group =
            new GolovanChartGroup(chartsPrefix, statsPrefix);

        GolovanChart chart = new GolovanChart(
            "-element-count",
            " average element count per instance",
            false,
            false,
            0d);
        String elementCountSignal =
            StringUtils.concat(statsPrefix, this.elementCountSignal);
        ImmutableGolovanPanelConfig config = panel.config();
        chart.addSplitSignal(
            config,
            "div(" + elementCountSignal
            + ',' + statsPrefix + "instance-alive_ammm)",
            1,
            true,
            false);
        group.addChart(chart);

        chart = new GolovanChart(
            "-weighted-size",
            " average weighted size per instance",
            false,
            false,
            0d);
        String weightedSizeSignal =
            StringUtils.concat(statsPrefix, this.weightedSizeSignal);
        chart.addSplitSignal(
            config,
            "div(" + weightedSizeSignal
            + ',' + statsPrefix + "instance-alive_ammm)",
            1,
            true,
            false);
        group.addChart(chart);

        if (averageSizeChart) {
            chart = new GolovanChart(
                "-entry-size",
                " average entry size (bytes)",
                false,
                false,
                0d);
            chart.addSplitSignal(
                config,
                "div(" + weightedSizeSignal
                + ',' + elementCountSignal + ')',
                1,
                true,
                false);
            group.addChart(chart);
        }

        panel.addCharts(category, title, group);
    }
}

