package ru.yandex.cache.async;

import org.apache.http.concurrent.FutureCallback;

public enum EmptyAsyncStorage
    implements AsyncStorage<Object, Object, RuntimeException>
{
    INSTANCE;

    @Override
    public void get(final Object key, final FutureCallback<Object> callback) {
        callback.completed(null);
    }

    @Override
    public void put(
        final Object key,
        final Object value,
        final long ttl,
        final FutureCallback<Void> callback)
    {
        callback.completed(null);
    }

    @Override
    public void close() {
    }

    @SuppressWarnings("unchecked")
    public static <K, V, E extends Exception> AsyncStorage<K, V, E> instance() {
        return (AsyncStorage<K, V, E>) INSTANCE;
    }
}

