package ru.yandex.cache.async;

import com.googlecode.concurrentlinkedhashmap.Weigher;

public class FixedWeigher implements Weigher<Object> {
    public static final FixedWeigher BOXED_NUMBER_WEIGHER =
        new FixedWeigher(
            ConcurrentLinkedHashMapAsyncStorage.OBJECT_WEIGHT
            + ConcurrentLinkedHashMapAsyncStorage.MEMBER_WEIGHT);

    private final int weight;

    public FixedWeigher(final int weight) {
        this.weight = weight;
    }

    @Override
    public int weightOf(Object value) {
        return weight;
    }
}

