package ru.yandex.cache.async;

import com.googlecode.concurrentlinkedhashmap.Weigher;

public enum LongArrayWeigher implements Weigher<long[]> {
    INSTANCE;

    @Override
    public int weightOf(final long[] value) {
        int len = value.length + 1;
        return ConcurrentLinkedHashMapAsyncStorage.OBJECT_WEIGHT
            + len * ConcurrentLinkedHashMapAsyncStorage.MEMBER_WEIGHT;
    }
}

