package ru.yandex.cache.async;

import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.AbstractFilterFutureCallback;

public class UnwrappingFutureCallback<T>
    extends AbstractFilterFutureCallback<AsyncCacheResult<T>, T>
{
    private final Consumer<AsyncCacheResultType> resultTypeConsumer;
    private final Logger logger;

    public UnwrappingFutureCallback(
        final FutureCallback<? super T> callback,
        final Consumer<AsyncCacheResultType> resultTypeConsumer,
        final Logger logger)
    {
        super(callback);
        this.resultTypeConsumer = resultTypeConsumer;
        this.logger = logger;
    }

    @Override
    public void completed(final AsyncCacheResult<T> result) {
        AsyncCacheResultType resultType = result.type();
        resultTypeConsumer.accept(resultType);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Cache result type: " + resultType);
        }
        callback.completed(result.value());
    }
}

