package ru.yandex.cache.async;

import com.googlecode.concurrentlinkedhashmap.Weigher;

import ru.yandex.concurrent.Weighable;

public enum WeighableWeigher implements Weigher<Weighable> {
    INSTANCE;

    @Override
    public int weightOf(final Weighable weighable) {
        return weighable.weight();
    }

    @SuppressWarnings("unchecked")
    public static <T extends Weighable> Weigher<T> instance() {
        return (Weigher<T>) INSTANCE;
    }
}

