package ru.yandex.backpack_multistarter;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import ru.yandex.msearch.Daemon;
import ru.yandex.multistarter.MultiStarter;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.search.backpack.client.BackPackClient;
import ru.yandex.search.backpack.client.BackPackClientConfigBuilder;


public final class BackpackMultistarter {
    private BackpackMultistarter() {
    }

    public static void main(final String[] args) {
        List<String> list = new ArrayList<String>(Arrays.asList(args));
        int idx = 0;
        try {
            // first argument - lucene daemon
            Daemon daemon = Daemon.createDaemon(list.get(idx));
            list.remove(idx);
            // second argument - backpack daemon
            new BackPackClient(new BackPackClientConfigBuilder( new IniConfig(
                    new File(list.get(idx)))).build(), daemon.index()).start();
            list.remove(idx);
            MultiStarter.main(list.toArray(new String[0]));
        } catch (Throwable t) {
            t.printStackTrace();
            System.exit(-1);
        }
    }
}

