package ru.yandex.blackbox;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.GoneException;
import ru.yandex.http.util.NotFoundException;

public abstract class AbstractBlackboxCallback<T, U>
    extends AbstractFilterFutureCallback<T, U>
{
    protected AbstractBlackboxCallback(
        final FutureCallback<? super U> callback)
    {
        super(callback);
    }

    @Override
    public void failed(final Exception e) {
        Exception ex;
        if (e instanceof BlackboxNotFoundException) {
            ex = new NotFoundException("User not found");
        } else if (e instanceof BlackboxFieldMissingException) {
            switch (((BlackboxFieldMissingException) e).dbfield()) {
                case MDB:
                case SUID:
                    ex = new GoneException("User has gone", e);
                    break;
                default:
                    ex = e;
                    break;
            }
        } else {
            ex = e;
        }
        callback.failed(ex);
    }
}

