package ru.yandex.blackbox;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

import ru.yandex.json.dom.JsonNull;
import ru.yandex.json.dom.JsonObject;

public enum BlackboxAliasType {

    PORTAL(1),
    MAIL(2),
    NAROD_MAIL(3),
    LITE(5),
    SOCIAL(6),
    PDD(7),
    PDDALIAS(8),
    ALTDOMAIN(9),
    PHONISH(10),
    PHONENUMBER(11),
    MAILISH(12),
    YANDEXOID(13),
    KINOPOISK_ID(15),
    UBER_ID(16),
    YAM_BOT(17),
    KOLONKISH(18),
    PUBLIC_ID(19),
    OLD_PUBLIC_ID(20),
    NEOPOLISH(21),
    KIDDISH(22),
    ;

    public static final Set<BlackboxAliasType> ALL = EnumSet.allOf(BlackboxAliasType.class);

    private final int id;

    BlackboxAliasType(final int id) {
        this.id = id;
    }

    public int id() {
        return id;
    }

    public void addToMap(
        final Map<BlackboxAliasType, JsonObject> map,
        final JsonObject value)
    {
        if (value != JsonNull.INSTANCE) {
            map.put(this, value);
        }
    }
}

