package ru.yandex.blackbox;

import java.util.Map;

import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonBadCastException;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonLong;
import ru.yandex.json.dom.JsonObject;

public enum BlackboxAttributeType {
    ACCOUNT_REGISTRATION_DATETIME(1),
    ACCOUNT_IS_MAILLIST(13),
    PERSON_COUNTRY(31),
    PHONE_CONFIRMATION_TIMESTAMP(36),
    IS_APP_PASSWORD_ENABLED(107),
    PHONES_SECURE(110),
    IS_SHARED(132),
    ACCOUNT_SMS_2FA_ON(200),
    DOCUMENTS_AGREEMENT_ACCEPTED(219),
    ACCOUNT_2FA_ON(1003),
    ACCOUNT_HAVE_PLUS(1015),
    ACCOUNT_CONNECT_ORGANIZATION_IDS(1017) {
        @Override
        @SuppressWarnings("StringSplitter")
        public void addToMap(
            final Map<BlackboxAttributeType, JsonObject> map,
            final JsonObject value)
            throws JsonBadCastException
        {
            if (value.type() == JsonObject.Type.STRING) {
                String stringValue = value.asString();
                if (!stringValue.isEmpty()) {
                    String[] parts = stringValue.split(",");
                    JsonList organizations = new JsonList(
                        BasicContainerFactory.INSTANCE,
                        parts.length);
                    for (String part: parts) {
                        try {
                            organizations.add(
                                new JsonLong(Long.parseLong(part)));
                        } catch (RuntimeException e) {
                            throw new JsonBadCastException(value, name());
                        }
                    }
                    map.put(this, organizations);
                }
            }
        }
    },
    ACCOUNT_ORG_ID(1031);

    private final int id;

    BlackboxAttributeType(final int id) {
        this.id = id;
    }

    public int id() {
        return id;
    }

    public void addToMap(
        final Map<BlackboxAttributeType, JsonObject> map,
        final JsonObject value)
        throws JsonBadCastException
    {
        JsonObject.Type type = value.type();
        if (type == JsonObject.Type.STRING) {
            String stringValue = value.asString();
            if (stringValue.isEmpty()) {
                return;
            }
        } else if (type == JsonObject.Type.NULL) {
            return;
        }
        map.put(this, value);
    }
}

